/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.assertions;

import com.eviware.soapui.config.LoadTestAssertionConfig;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.AbstractLoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.support.Configurable;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import org.apache.xmlbeans.XmlObject;

public class MaxErrorsAssertion
extends AbstractLoadTestAssertion
implements Configurable {
    private static final String NAME_FIELD = "Name";
    private static final String NAME_ELEMENT = "name";
    private static final String MAX_ABSOLUTE_ERRORS_ELEMENT = "max-absolute-errors";
    private static final String MAX_ABSOLUTE_ERRORS_FIELD = "Max Absolute Errors";
    private static final String MAX_RELATIVE_ERRORS_ELEMENT = "max-relative-errors";
    private static final String MAX_RELATIVE_ERRORS_FIELD = "Max Relative Errors";
    private float maxRelativeErrors;
    private int maxAbsoluteErrors;
    private XFormDialog dialog;
    public static final String MAX_ERRORS_TYPE = "Max Errors";

    public MaxErrorsAssertion(LoadTestAssertionConfig assertionConfig, WsdlLoadTest loadTest) {
        super(assertionConfig, loadTest);
        this.init(assertionConfig);
        this.initIcon("/errors_loadtest_assertion.gif");
    }

    private void init(LoadTestAssertionConfig assertionConfig) {
        XmlObject configuration = assertionConfig.getConfiguration();
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(configuration);
        this.setName(reader.readString(NAME_ELEMENT, MAX_ERRORS_TYPE));
        this.maxAbsoluteErrors = reader.readInt(MAX_ABSOLUTE_ERRORS_ELEMENT, 100);
        this.maxRelativeErrors = reader.readFloat(MAX_RELATIVE_ERRORS_ELEMENT, 0.2f);
        this.setTargetStep(reader.readString("test-step", "- Total -"));
    }

    @Override
    public String getDescription() {
        return "testStep: " + this.getTargetStep() + ", maxAbsoluteErrors: " + this.maxAbsoluteErrors + ", maxRelativeErrors; " + this.maxRelativeErrors;
    }

    @Override
    public String assertResult(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestStepResult result, TestCaseRunner testRunner, TestCaseRunContext runContext) {
        TestStep step = result.getTestStep();
        if (this.targetStepMatches(step)) {
            WsdlLoadTest loadTest = (WsdlLoadTest)loadTestRunner.getLoadTest();
            LoadTestLog loadTestLog = loadTest.getLoadTestLog();
            int errorCount = loadTestLog.getErrorCount(step.getName());
            if (this.maxAbsoluteErrors >= 0 && errorCount > this.maxAbsoluteErrors) {
                loadTestRunner.fail("Maximum number of errors [" + this.maxAbsoluteErrors + "] exceeded for step [" + step.getName() + "]");
            }
            int index = step.getTestCase().getIndexOfTestStep(step);
            LoadTestStatistics statisticsModel = loadTest.getStatisticsModel();
            long totalSteps = statisticsModel.getStatistic(index, LoadTestStatistics.Statistic.COUNT);
            float relativeErrors = (float)errorCount / (float)totalSteps;
            if (this.maxRelativeErrors > 0.0f && relativeErrors > this.maxRelativeErrors) {
                loadTestRunner.fail("Maximum relative number of errors [" + this.maxRelativeErrors + "] exceeded for step [" + step.getName() + "]");
            }
        }
        return null;
    }

    @Override
    public String assertResults(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
        if ("- Total -".equals(this.getTargetStep())) {
            WsdlLoadTest loadTest = (WsdlLoadTest)loadTestRunner.getLoadTest();
            LoadTestLog loadTestLog = loadTest.getLoadTestLog();
            int errorCount = loadTestLog.getErrorCount(null);
            if (this.maxAbsoluteErrors >= 0 && errorCount > this.maxAbsoluteErrors) {
                loadTestRunner.fail("Maximum number of errors [" + this.maxAbsoluteErrors + "] exceeded");
            }
            LoadTestStatistics statisticsModel = loadTest.getStatisticsModel();
            long totalSteps = statisticsModel.getStatistic(-1, LoadTestStatistics.Statistic.COUNT);
            float relativeErrors = (float)errorCount / (float)totalSteps;
            if (this.maxRelativeErrors > 0.0f && relativeErrors > this.maxRelativeErrors) {
                loadTestRunner.fail("Maximum relative number of errors [" + this.maxRelativeErrors + "] exceeded");
            }
        }
        return null;
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(NAME_FIELD, this.getName());
        values.put(MAX_ABSOLUTE_ERRORS_FIELD, String.valueOf(this.maxAbsoluteErrors));
        values.put(MAX_RELATIVE_ERRORS_FIELD, String.valueOf(this.maxRelativeErrors));
        values.put("TestStep", this.getTargetStep());
        this.dialog.setOptions("TestStep", this.getTargetStepOptions(true));
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            try {
                this.maxAbsoluteErrors = Integer.parseInt((String)values.get(MAX_ABSOLUTE_ERRORS_FIELD));
                this.maxRelativeErrors = Float.parseFloat((String)values.get(MAX_RELATIVE_ERRORS_FIELD));
                this.setTargetStep((String)values.get("TestStep"));
                this.setName((String)values.get(NAME_FIELD));
            }
            catch (Exception e) {
                UISupport.showErrorMessage(e.getMessage());
            }
            this.updateConfiguration();
            return true;
        }
        return false;
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Max Errors Assertion");
        XForm form = builder.createForm("Basic");
        form.addTextField(NAME_FIELD, "Name of this assertion", XForm.FieldType.TEXT);
        form.addTextField(MAX_ABSOLUTE_ERRORS_FIELD, "Maximum number of errors before failing", XForm.FieldType.TEXT);
        form.addTextField(MAX_RELATIVE_ERRORS_FIELD, "Relative maximum number of errors before failing (0-1)", XForm.FieldType.TEXT);
        form.addComboBox("TestStep", new String[0], "TestStep to assert");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/Load-Testing/max-errors-assertion.html"), "Specify options for this Max Errors Assertion", UISupport.OPTIONS_ICON);
    }

    @Override
    protected void updateConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(NAME_ELEMENT, this.getName());
        builder.add(MAX_ABSOLUTE_ERRORS_ELEMENT, this.maxAbsoluteErrors);
        builder.add(MAX_RELATIVE_ERRORS_ELEMENT, this.maxRelativeErrors);
        builder.add("test-step", this.getTargetStep());
        this.setConfiguration(builder.finish());
    }
}

