/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testsuite;

import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;

public class CloneTestSuiteAction
extends AbstractSoapUIAction<WsdlTestSuite> {
    private XFormDialog dialog;

    public CloneTestSuiteAction() {
        super("Clone TestSuite", "Clones this TestSuite");
    }

    @Override
    public void perform(final WsdlTestSuite testSuite, Object param) {
        if (this.dialog == null) {
            DefaultActionList actions = new DefaultActionList();
            AbstractAction cloneAction = new AbstractAction("Clone"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CloneTestSuiteAction.this.dialog.validate()) {
                        CloneTestSuiteAction.this.dialog.setVisible(false);
                        String targetProjectName = CloneTestSuiteAction.this.dialog.getValue("Target Project");
                        String name = CloneTestSuiteAction.this.dialog.getValue("TestSuite Name");
                        WsdlProject project = testSuite.getProject();
                        boolean move = CloneTestSuiteAction.this.dialog.getBooleanValue("Move instead");
                        boolean cloneDescription = CloneTestSuiteAction.this.dialog.getBooleanValue("Clone description");
                        String description = testSuite.getDescription();
                        if (!cloneDescription) {
                            description = CloneTestSuiteAction.this.dialog.getValue("Description");
                        }
                        TestSuite result = targetProjectName.equals(testSuite.getProject().getName()) ? CloneTestSuiteAction.cloneTestSuiteWithinProject(testSuite, name, project, description) : CloneTestSuiteAction.cloneToAnotherProject(testSuite, targetProjectName, name, move, description);
                        if (move && result != null) {
                            testSuite.getProject().removeTestSuite(testSuite);
                        }
                    }
                }
            };
            actions.addAction(cloneAction);
            actions.addAction(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloneTestSuiteAction.this.dialog.setVisible(false);
                }
            });
            actions.setDefaultAction(cloneAction);
            this.dialog = ADialogBuilder.buildDialog(Form.class, (ActionList)actions, false);
        }
        this.dialog.getFormField("Clone description").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                if (CloneTestSuiteAction.this.dialog.getBooleanValue("Clone description")) {
                    CloneTestSuiteAction.this.dialog.getFormField("Description").setEnabled(false);
                } else {
                    CloneTestSuiteAction.this.dialog.getFormField("Description").setEnabled(true);
                }
            }
        });
        this.dialog.setValue("TestSuite Name", "Copy of " + testSuite.getName());
        this.dialog.setBooleanValue("Move instead", false);
        this.dialog.setBooleanValue("Clone description", true);
        this.dialog.getFormField("Description").setEnabled(false);
        this.dialog.setValue("Description", testSuite.getDescription());
        WorkspaceImpl workspace = testSuite.getProject().getWorkspace();
        this.dialog.setOptions("Target Project", ModelSupport.getNames(workspace.getOpenProjectList(), new String[]{"<Create New>"}));
        this.dialog.setValue("Target Project", testSuite.getProject().getName());
        this.dialog.show();
    }

    public static WsdlTestSuite cloneToAnotherProject(WsdlTestSuite testSuite, String targetProjectName, String name, boolean move, String description) {
        Set<Interface> requiredInterfaces;
        WorkspaceImpl workspace = testSuite.getProject().getWorkspace();
        WsdlProject targetProject = (WsdlProject)workspace.getProjectByName(targetProjectName);
        if (targetProject == null) {
            targetProjectName = UISupport.prompt("Enter name for new Project", "Clone TestSuite", "");
            if (targetProjectName == null) {
                return null;
            }
            try {
                targetProject = workspace.createProject(targetProjectName, null);
            }
            catch (SoapUIException e) {
                UISupport.showErrorMessage(e);
            }
            if (targetProject == null) {
                return null;
            }
        }
        if ((requiredInterfaces = CloneTestSuiteAction.getRequiredInterfaces(testSuite, targetProject)).size() > 0) {
            String msg = "Target project [" + targetProjectName + "] is missing required Interfaces;\r\n\r\n";
            for (Interface iface : requiredInterfaces) {
                msg = msg + iface.getName() + " [" + iface.getTechnicalId() + "]\r\n";
            }
            Boolean result = UISupport.confirmOrCancel(msg = msg + "\r\nShould these be cloned to the targetProject as well?", "Clone TestSuite");
            if (result == null) {
                return null;
            }
            if (result.booleanValue()) {
                for (Interface iface : requiredInterfaces) {
                    targetProject.importInterface((AbstractInterface)iface, true, true);
                }
            }
        }
        testSuite = targetProject.importTestSuite(testSuite, name, -1, !move, description);
        UISupport.select(testSuite);
        return testSuite;
    }

    public static TestSuite cloneTestSuiteWithinProject(WsdlTestSuite testSuite, String name, WsdlProject project, String description) {
        WsdlTestSuite newTestSuite = project.importTestSuite(testSuite, name, -1, true, description);
        UISupport.select(newTestSuite);
        return newTestSuite;
    }

    public static Set<Interface> getRequiredInterfaces(WsdlTestSuite testSuite, WsdlProject targetProject) {
        HashSet<Interface> requiredInterfaces = new HashSet<Interface>();
        for (int i = 0; i < testSuite.getTestCaseCount(); ++i) {
            WsdlTestCase testCase = testSuite.getTestCaseAt(i);
            for (int y = 0; y < testCase.getTestStepCount(); ++y) {
                WsdlTestStep testStep = testCase.getTestStepAt(y);
                requiredInterfaces.addAll(testStep.getRequiredInterfaces());
            }
        }
        if (requiredInterfaces.size() > 0 && targetProject.getInterfaceCount() > 0) {
            HashMap<String, Interface> bindings = new HashMap<String, Interface>();
            for (Interface iface : requiredInterfaces) {
                bindings.put(iface.getTechnicalId(), iface);
            }
            for (Interface iface : targetProject.getInterfaceList()) {
                bindings.remove(iface.getTechnicalId());
            }
            requiredInterfaces.retainAll(bindings.values());
        }
        return requiredInterfaces;
    }

    @AForm(description="Specify target Project and name of cloned TestSuite", name="Clone TestSuite", helpUrl="http://www.soapui.org/Functional-Testing/structuring-and-running-tests.html", icon="/applications-system.png")
    protected static interface Form {
        @AField(name="TestSuite Name", description="The name of the cloned TestSuite", type=AField.AFieldType.STRING)
        public static final String NAME = "TestSuite Name";
        @AField(name="Target Project", description="The target Project for the cloned TestSuite", type=AField.AFieldType.ENUMERATION)
        public static final String PROJECT = "Target Project";
        @AField(name="Move instead", description="Moves the selected TestSuite instead of copying", type=AField.AFieldType.BOOLEAN)
        public static final String MOVE = "Move instead";
        @AField(name="Clone description", description="Clones the description of selected TestSuite", type=AField.AFieldType.BOOLEAN)
        public static final String CLONE_DESCRIPTION = "Clone description";
        @AField(name="Description", description="Description of new TestSuite", type=AField.AFieldType.STRINGAREA)
        public static final String DESCRIPTION = "Description";
    }
}

