/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockservice;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;

public class MockServiceOptionsAction
extends AbstractSoapUIAction<WsdlMockService> {
    private XFormDialog dialog;

    public MockServiceOptionsAction() {
        super("Options", "Sets options for this MockService");
    }

    @Override
    public void perform(WsdlMockService mockService, Object param) {
        if (mockService.getMockRunner() != null && mockService.getMockRunner().isRunning()) {
            UISupport.showErrorMessage("Can not set MockService options while running");
            return;
        }
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(OptionsForm.class);
        }
        this.dialog.setValue("Path", mockService.getPath());
        this.dialog.setValue("Host", mockService.getHost());
        this.dialog.setIntValue("Port", mockService.getPort());
        this.dialog.setBooleanValue("Host Only", mockService.getBindToHostOnly());
        this.dialog.setValue("Docroot", mockService.getDocroot());
        this.dialog.setOptions("Fault Operation", ModelSupport.getNames(new String[]{"- none -"}, mockService.getMockOperationList()));
        this.dialog.setValue("Fault Operation", String.valueOf(mockService.getFaultMockOperation()));
        if (this.dialog.show()) {
            mockService.setPath(this.dialog.getValue("Path"));
            mockService.setPort(this.dialog.getIntValue("Port", mockService.getPort()));
            mockService.setHost(this.dialog.getValue("Host"));
            mockService.setBindToHostOnly(this.dialog.getBooleanValue("Host Only"));
            mockService.setDocroot(this.dialog.getValue("Docroot"));
            mockService.setFaultMockOperation((WsdlMockOperation)mockService.getMockOperationByName(this.dialog.getValue("Fault Operation")));
        }
    }

    @AForm(name="SOAP MockService Options", description="Set options for this SOAP mock service", helpUrl="http://www.soapui.org/Service-Mocking/mock-service-editor.html", icon="/preferences-system.png")
    private class OptionsForm {
        @AField(name="Path", description="The path this MockService will mount on")
        public static final String PATH = "Path";
        @AField(name="Port", description="The port this MockService will mount on", type=AField.AFieldType.INT)
        public static final String PORT = "Port";
        @AField(name="Host", description="The local host to bind to and use in Port endpoints")
        public static final String HOST = "Host";
        @AField(name="Host Only", description="Only binds to specified host", type=AField.AFieldType.BOOLEAN)
        public static final String HOSTONLY = "Host Only";
        @AField(name="Docroot", description="The document root to serve (empty = none)", type=AField.AFieldType.FOLDER)
        public static final String DOCROOT = "Docroot";
        @AField(name="Fault Operation", description="The MockOperation that should handle incoming SOAP Faults", type=AField.AFieldType.ENUMERATION)
        public static final String FAULT_OPERATION = "Fault Operation";

        private OptionsForm() {
        }
    }
}

