/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.soapui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.XFormTextField;
import com.eviware.x.impl.swing.JTextAreaFormField;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class LoadTestRunnerAction
extends AbstractToolsAction<WsdlProject> {
    private static final String ALL_VALUE = "<all>";
    protected static final String ENVIRONMENT = "Environment";
    protected static final String ENDPOINT = "Endpoint";
    protected static final String HOSTPORT = "Host:Port";
    private static final String LIMIT = "Limit";
    private static final String TESTSUITE = "TestSuite";
    private static final String TESTCASE = "TestCase";
    private static final String LOADTEST = "LoadTest";
    private static final String THREADCOUNT = "ThreadCount";
    protected static final String USERNAME = "Username";
    protected static final String PASSWORD = "Password";
    protected static final String DOMAIN = "Domain";
    private static final String PRINTREPORTSTATISTICS = "Print Report Statistics";
    private static final String ROOTFOLDER = "Root Folder";
    private static final String TESTRUNNERPATH = "TestRunner Path";
    private static final String SAVEPROJECT = "Save Project";
    private static final String ADDSETTINGS = "Add Settings";
    private static final String PROJECTPASSWORD = "Project Password";
    private static final String SAVEAFTER = "Save After";
    protected static final String WSSTYPE = "WSS Password Type";
    private static final String OPEN_REPORT = "Open Report";
    private static final String GENERATEREPORTSEACHTESTCASE = "Report to Generate";
    private static final String REPORTFORMAT = "Report Format(s)";
    private static final String GLOBALPROPERTIES = "Global Properties";
    private static final String SYSTEMPROPERTIES = "System Properties";
    private static final String PROJECTPROPERTIES = "Project Properties";
    private XForm mainForm;
    private static final Logger log = Logger.getLogger(LoadTestRunnerAction.class);
    public static final String SOAPUI_ACTION_ID = "LoadTestRunnerAction";
    protected XForm advForm;
    private XForm propertyForm;
    private XForm reportForm;
    private boolean updating;
    private boolean proVersion;

    public LoadTestRunnerAction() {
        super("Launch LoadTestRunner", "Launch command-line LoadTestRunner for this project");
    }

    @Override
    protected XFormDialog buildDialog(WsdlProject modelItem) {
        if (modelItem == null) {
            return null;
        }
        this.proVersion = this.isProVersion(modelItem);
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Launch LoadTestRunner");
        this.mainForm = builder.createForm("Basic");
        this.mainForm.addComboBox(TESTSUITE, new String[0], "The TestSuite to run").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                LoadTestRunnerAction.this.updateCombos();
            }
        });
        this.mainForm.addComboBox(TESTCASE, new String[0], "The TestCase to run").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                LoadTestRunnerAction.this.updateCombos();
            }
        });
        this.mainForm.addComboBox(LOADTEST, new String[0], "The LoadTest to run");
        this.mainForm.addSeparator();
        XFormTextField path = this.mainForm.addTextField(TESTRUNNERPATH, "Folder containing TestRunner.bat to use", XForm.FieldType.FOLDER);
        path.setValue(System.getProperty("soapui.home", ""));
        this.mainForm.addCheckBox(SAVEPROJECT, "Saves project before running").setEnabled(!modelItem.isRemote());
        this.mainForm.addCheckBox(SAVEAFTER, "Sets to save the project file after tests have been run");
        this.mainForm.addCheckBox(ADDSETTINGS, "Adds global settings to command-line");
        this.mainForm.addSeparator();
        this.mainForm.addTextField(PROJECTPASSWORD, "Set project password", XForm.FieldType.PASSWORD);
        this.mainForm.addTextField("user-settings.xml Password", "Set soapui-settings.xml password", XForm.FieldType.PASSWORD);
        this.advForm = builder.createForm("Overrides");
        this.advForm.addComboBox(ENVIRONMENT, new String[]{"Default"}, "The environment to set for all requests").setEnabled(this.proVersion);
        this.advForm.addComboBox(ENDPOINT, new String[]{""}, "endpoint to forward to");
        this.advForm.addTextField(HOSTPORT, "Host:Port to use for requests", XForm.FieldType.TEXT);
        this.advForm.addTextField(LIMIT, "Limit for LoadTest", XForm.FieldType.TEXT);
        this.advForm.addTextField(THREADCOUNT, "ThreadCount for LoadTest", XForm.FieldType.TEXT);
        this.advForm.addSeparator();
        this.advForm.addTextField(USERNAME, "The username to set for all requests", XForm.FieldType.TEXT);
        this.advForm.addTextField(PASSWORD, "The password to set for all requests", XForm.FieldType.PASSWORD);
        this.advForm.addTextField(DOMAIN, "The domain to set for all requests", XForm.FieldType.TEXT);
        this.advForm.addComboBox(WSSTYPE, new String[]{"", "Text", "Digest"}, "The username to set for all requests");
        this.reportForm = builder.createForm("Reports");
        this.createReportTab();
        this.propertyForm = builder.createForm("Properties");
        this.propertyForm.addComponent(GLOBALPROPERTIES, this.createTextArea());
        this.propertyForm.addComponent(SYSTEMPROPERTIES, this.createTextArea());
        this.propertyForm.addComponent(PROJECTPROPERTIES, this.createTextArea());
        this.setToolsSettingsAction(null);
        this.buildArgsForm(builder, false, "TestRunner");
        return builder.buildDialog(this.buildDefaultActions("http://www.soapui.org/Test-Automation/launch-testrunner.html", modelItem), "Specify arguments for launching SoapUI LoadTestRunner", UISupport.TOOL_ICON);
    }

    private void createReportTab() {
        this.reportForm.addCheckBox(PRINTREPORTSTATISTICS, "Creates a report statistics in the specified folder");
        this.reportForm.addTextField(ROOTFOLDER, "Folder for reporting", XForm.FieldType.FOLDER);
        this.reportForm.addCheckBox(OPEN_REPORT, "Opens generated report(s) in browser (SoapUI Pro only)").setEnabled(this.proVersion);
        this.reportForm.addTextField(GENERATEREPORTSEACHTESTCASE, "Report to Generate (SoapUI Pro only)", XForm.FieldType.TEXT).setEnabled(this.proVersion);
        this.reportForm.addTextField(REPORTFORMAT, "Choose report format(s), comma-separated (SoapUI Pro only)", XForm.FieldType.TEXT).setEnabled(this.proVersion);
    }

    private JTextAreaFormField createTextArea() {
        JTextAreaFormField textArea = new JTextAreaFormField();
        textArea.setWidth(40);
        textArea.getTextArea().setRows(4);
        textArea.setToolTip("name=value pairs separated by space or enter");
        return textArea;
    }

    @Override
    protected Action createRunOption(WsdlProject modelItem) {
        Action action = super.createRunOption(modelItem);
        action.putValue("Name", "Launch");
        return action;
    }

    @Override
    protected StringToStringMap initValues(WsdlProject modelItem, Object param) {
        if (modelItem != null && this.mainForm != null) {
            ArrayList<String> endpoints = new ArrayList<String>();
            for (Interface iface : modelItem.getInterfaceList()) {
                for (String endpoint : iface.getEndpoints()) {
                    if (endpoints.contains(endpoint)) continue;
                    endpoints.add(endpoint);
                }
            }
            endpoints.add(0, null);
            this.advForm.setOptions(ENDPOINT, endpoints.toArray());
            List<TestSuite> testSuites = modelItem.getTestSuiteList();
            for (int c = 0; c < testSuites.size(); ++c) {
                int cnt = 0;
                for (TestCase testCase : testSuites.get(c).getTestCaseList()) {
                    cnt += testCase.getLoadTestCount();
                }
                if (cnt != 0) continue;
                testSuites.remove(c);
                --c;
            }
            this.mainForm.setOptions(TESTSUITE, ModelSupport.getNames(new String[]{ALL_VALUE}, testSuites));
        } else if (this.mainForm != null) {
            this.mainForm.setOptions(ENDPOINT, new String[]{null});
        }
        this.initEnvironment(modelItem);
        StringToStringMap values = super.initValues(modelItem, param);
        this.updateCombos();
        if (this.mainForm != null && param instanceof WsdlLoadTest) {
            this.mainForm.getFormField(TESTSUITE).setValue(((WsdlLoadTest)param).getTestCase().getTestSuite().getName());
            this.mainForm.getFormField(TESTCASE).setValue(((WsdlLoadTest)param).getTestCase().getName());
            this.mainForm.getFormField(LOADTEST).setValue(((WsdlLoadTest)param).getName());
            values.put(TESTSUITE, this.mainForm.getComponentValue(TESTSUITE));
            values.put(TESTCASE, this.mainForm.getComponentValue(TESTCASE));
            values.put(LOADTEST, this.mainForm.getComponentValue(LOADTEST));
            this.mainForm.getComponent(SAVEPROJECT).setEnabled(!modelItem.isRemote());
        }
        return values;
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, WsdlProject modelItem) throws Exception {
        String testRunnerDir = this.mainForm.getComponentValue(TESTRUNNERPATH);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(modelItem);
        builder.command(args.getArgs());
        if (StringUtils.isNullOrEmpty(testRunnerDir)) {
            builder.directory(new File("."));
        } else {
            builder.directory(new File(testRunnerDir));
        }
        if (this.mainForm.getComponentValue(SAVEPROJECT).equals(Boolean.TRUE.toString())) {
            modelItem.save();
        } else if (StringUtils.isNullOrEmpty(modelItem.getPath())) {
            UISupport.showErrorMessage("Project [" + modelItem.getName() + "] has not been saved to file.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launching loadtestrunner in directory [" + builder.directory() + "] with arguments [" + args.toString() + "]"));
        }
        toolHost.run(new ProcessToolRunner(builder, "SoapUI LoadTestRunner", (ModelItem)modelItem, args));
    }

    private ArgumentBuilder buildArgs(WsdlProject modelItem) throws IOException {
        XFormDialog dialog = this.getDialog();
        if (dialog == null) {
            ArgumentBuilder builder = new ArgumentBuilder(new StringToStringMap());
            builder.startScript("loadtestrunner", ".bat", ".sh");
            return builder;
        }
        StringToStringMap values = dialog.getValues();
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript("loadtestrunner", ".bat", ".sh");
        builder.addString(ENDPOINT, "-e", "");
        builder.addString(HOSTPORT, "-h", "");
        if (!((String)values.get(TESTSUITE)).equals(ALL_VALUE)) {
            builder.addString(TESTSUITE, "-s", "");
        }
        if (!((String)values.get(TESTCASE)).equals(ALL_VALUE)) {
            builder.addString(TESTCASE, "-c", "");
        }
        if (!((String)values.get(LOADTEST)).equals(ALL_VALUE)) {
            builder.addString(LOADTEST, "-l", "");
        }
        builder.addString(LIMIT, "-m", "");
        builder.addString(THREADCOUNT, "-n", "");
        builder.addString(USERNAME, "-u", "");
        builder.addStringShadow(PASSWORD, "-p", "");
        builder.addString(DOMAIN, "-d", "");
        builder.addBoolean(PRINTREPORTSTATISTICS, "-r");
        builder.addString(ROOTFOLDER, "-f", "");
        builder.addStringShadow(PROJECTPASSWORD, "-x", "");
        builder.addStringShadow("user-settings.xml Password", "-v", "");
        builder.addBoolean(SAVEAFTER, "-S");
        builder.addString(WSSTYPE, "-w", "");
        if (this.proVersion) {
            builder.addBoolean(OPEN_REPORT, "-o");
            builder.addString(GENERATEREPORTSEACHTESTCASE, "-R", "");
            builder.addStrings(REPORTFORMAT, "-F", ",");
            builder.addString(ENVIRONMENT, "-E", "");
        }
        this.addPropertyArguments(builder);
        if (dialog.getBooleanValue(ADDSETTINGS)) {
            try {
                builder.addBoolean(ADDSETTINGS, "-t" + SoapUI.saveSettings());
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        builder.addArgs(modelItem.getPath());
        this.addToolArgs(values, builder);
        return builder;
    }

    private void updateCombos() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        ArrayList<String> testCases = new ArrayList<String>();
        ArrayList<String> loadTests = new ArrayList<String>();
        WsdlTestSuite ts = ((WsdlProject)this.getModelItem()).getTestSuiteByName(this.mainForm.getComponentValue(TESTSUITE));
        String testCaseName = this.mainForm.getComponentValue(TESTCASE);
        if (ALL_VALUE.equals(testCaseName)) {
            testCaseName = null;
        }
        for (TestSuite testSuite : ((WsdlProject)this.getModelItem()).getTestSuiteList()) {
            if (ts != null && testSuite != ts) continue;
            for (TestCase testCase : testSuite.getTestCaseList()) {
                if (testCase.getLoadTestCount() == 0) continue;
                if (!testCases.contains(testCase.getName())) {
                    testCases.add(testCase.getName());
                }
                if (testCaseName != null && !testCase.getName().equals(testCaseName)) continue;
                for (LoadTest loadTest : testCase.getLoadTestList()) {
                    if (loadTests.contains(loadTest.getName())) continue;
                    loadTests.add(loadTest.getName());
                }
            }
        }
        testCases.add(0, ALL_VALUE);
        this.mainForm.setOptions(TESTCASE, testCases.toArray());
        loadTests.add(0, ALL_VALUE);
        this.mainForm.setOptions(LOADTEST, loadTests.toArray());
        this.updating = false;
    }

    private boolean isProVersion(WsdlProject modelItem) {
        return modelItem.getClass().getName().contains("WsdlProjectPro");
    }

    private void addPropertyArguments(ArgumentBuilder builder) {
        ArrayList<String> propertyArguments = new ArrayList<String>();
        this.addProperties(propertyArguments, GLOBALPROPERTIES, "-G");
        this.addProperties(propertyArguments, SYSTEMPROPERTIES, "-D");
        this.addProperties(propertyArguments, PROJECTPROPERTIES, "-P");
        builder.addArgs(propertyArguments.toArray(new String[propertyArguments.size()]));
    }

    private void addProperties(List<String> propertyArguments, String propertyDomain, String arg) {
        StringTokenizer tokenizer = new StringTokenizer(this.getDialog().getValue(propertyDomain));
        while (tokenizer.hasMoreTokens()) {
            propertyArguments.add(arg + tokenizer.nextToken());
        }
    }

    protected void initEnvironment(WsdlProject modelItem) {
    }
}

