/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support.handlers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AbstractRequestConfig;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.support.MediaTypeHandler;
import com.eviware.soapui.impl.rest.support.handlers.JsonXmlSerializer;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.iface.TypedContent;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.net.URL;
import net.sf.json.JSON;
import net.sf.json.JSONException;

public class JsonMediaTypeHandler
implements MediaTypeHandler {
    @Override
    public boolean canHandle(String contentType) {
        return JsonUtil.seemsToBeJsonContentType(contentType);
    }

    @Override
    public String createXmlRepresentation(HttpResponse response) {
        try {
            String content = response.getContentAsString().trim();
            if (!StringUtils.hasContent(content)) {
                return null;
            }
            content = content.replaceAll("\\\\u0000", "");
            JSON json = new JsonUtil().parseTrimmedText(content);
            JsonXmlSerializer serializer = new JsonXmlSerializer();
            serializer.setTypeHintsEnabled(false);
            serializer.setRootName(HttpUtils.isErrorStatus(response.getStatusCode()) ? "Fault" : "Response");
            URL url = response.getURL();
            String originalUri = this.readOriginalUriFrom(response.getRequest());
            String namespaceUri = originalUri != null ? originalUri : JsonMediaTypeHandler.makeNamespaceUriFrom(url);
            serializer.setNamespace("", namespaceUri);
            content = serializer.write(json);
            content = XmlUtils.prettyPrintXml(content);
            return content;
        }
        catch (JSONException ignore) {
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return "<xml/>";
    }

    @Override
    public String createXmlRepresentation(TypedContent typedContent) {
        try {
            String content = typedContent.getContentAsString().trim();
            if (!StringUtils.hasContent(content)) {
                return null;
            }
            content = content.replaceAll("\\\\u0000", "");
            JSON json = new JsonUtil().parseTrimmedText(content);
            JsonXmlSerializer serializer = new JsonXmlSerializer();
            serializer.setTypeHintsEnabled(false);
            serializer.setRootName("Response");
            serializer.setNamespace("", "json");
            content = serializer.write(json);
            content = XmlUtils.prettyPrintXml(content);
            return content;
        }
        catch (JSONException ignore) {
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        return "<xml/>";
    }

    private String readOriginalUriFrom(AbstractHttpRequestInterface<?> request) {
        if (request instanceof RestRequest) {
            AbstractRequestConfig config = (AbstractRequestConfig)((RestRequest)request).getConfig();
            String originalUri = config.getOriginalUri();
            if (originalUri != null && originalUri.contains("{")) {
                return null;
            }
            return originalUri;
        }
        return null;
    }

    public static String makeNamespaceUriFrom(URL url) {
        return url.getProtocol() + "://" + url.getHost() + url.getPath();
    }
}

