/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request;

import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.actions.support.NewRestResourceActionBase;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.model.support.TestPropertyListenerAdapter;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.xmlbeans.impl.values.XmlValueDisconnectedException;

public abstract class AbstractRestRequestDesktopPanel<T extends ModelItem, T2 extends RestRequestInterface>
extends AbstractHttpXmlRequestDesktopPanel<T, T2> {
    protected static final int STANDARD_TOOLBAR_HEIGHT = 45;
    private InternalTestPropertyListener testPropertyListener = new InternalTestPropertyListener();
    private RestParamPropertyChangeListener restParamPropertyChangeListener = new RestParamPropertyChangeListener();

    public AbstractRestRequestDesktopPanel(T modelItem, T2 requestItem) {
        super(modelItem, requestItem);
        this.addPropertyChangeListenerToResource(requestItem);
        requestItem.addTestPropertyListener(this.testPropertyListener);
        requestItem.getOperation().getInterface().addPropertyChangeListener(new EndpointChangeListener());
        for (TestProperty param : requestItem.getParams().getProperties().values()) {
            ((RestParamProperty)param).addPropertyChangeListener(this.restParamPropertyChangeListener);
        }
    }

    private void addPropertyChangeListenerToResource(T2 requestItem) {
        if (requestItem.getResource() != null) {
            requestItem.getResource().addPropertyChangeListener(this);
            requestItem.getResource().addTestPropertyListener(this.testPropertyListener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.updateUiValues();
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        return ((RestRequestInterface)this.getRequest()).submit(new WsdlSubmitContext((ModelItem)this.getModelItem()), true);
    }

    @Override
    protected String getHelpUrl() {
        return null;
    }

    @Override
    protected JComponent buildToolbar() {
        if (((RestRequestInterface)this.getRequest()).getResource() != null) {
            JPanel panel = new JPanel(new BorderLayout());
            JXToolBar topToolBar = UISupport.createToolbar();
            JButton submitButton = super.getSubmitButton();
            topToolBar.add(submitButton);
            topToolBar.add(this.getCancelButton());
            this.insertButtons(topToolBar);
            JPanel endpointPanel = new JPanel(new BorderLayout());
            endpointPanel.setMinimumSize(new Dimension(75, 45));
            JPanel comboBoxPanel = this.buildEndpointPanel();
            JLabel endPointLabel = new JLabel("Endpoint");
            endpointPanel.add((Component)endPointLabel, "North");
            endpointPanel.add((Component)comboBoxPanel, "South");
            topToolBar.add(Box.createHorizontalStrut(4));
            topToolBar.addWithOnlyMinimumHeight(endpointPanel);
            topToolBar.add(Box.createHorizontalStrut(4));
            this.addTopToolbarComponents(topToolBar);
            topToolBar.add(Box.createHorizontalGlue());
            topToolBar.add(this.getTabsButton());
            topToolBar.add(this.getSplitButton());
            topToolBar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction(this.getHelpUrl())));
            int maximumPreferredHeight = this.findMaximumPreferredHeight(topToolBar) + 6;
            topToolBar.setPreferredSize(new Dimension(600, Math.max(maximumPreferredHeight, 45)));
            panel.add((Component)topToolBar, "North");
            this.addBottomToolbar(panel);
            return panel;
        }
        return super.buildToolbar();
    }

    protected int findMaximumPreferredHeight(Container parent) {
        int maximum = 0;
        for (Component component : parent.getComponents()) {
            int componentPreferredHeight = component == null || component.getPreferredSize() == null ? 0 : component.getPreferredSize().height;
            maximum = Math.max(maximum, componentPreferredHeight);
        }
        return maximum;
    }

    protected abstract void addTopToolbarComponents(JXToolBar var1);

    protected abstract void addBottomToolbar(JPanel var1);

    protected abstract void updateUiValues();

    @Override
    protected boolean release() {
        if (((RestRequestInterface)this.getRequest()).getResource() != null) {
            ((RestRequestInterface)this.getRequest()).getResource().removePropertyChangeListener(this);
        }
        ((RestRequestInterface)this.getRequest()).removeTestPropertyListener(this.testPropertyListener);
        for (TestProperty param : ((RestRequestInterface)this.getRequest()).getParams().getProperties().values()) {
            ((RestParamProperty)param).removePropertyChangeListener(this.restParamPropertyChangeListener);
        }
        return super.release();
    }

    private void addPropertyToLevel(String name, String value, RestParamsPropertyHolder.ParameterStyle style, NewRestResourceActionBase.ParamLocation location, String requestLevelValue) {
        RestParamsPropertyHolder paramsPropertyHolder = null;
        switch (location) {
            case METHOD: {
                paramsPropertyHolder = ((RestRequestInterface)this.getRequest()).getRestMethod().getParams();
                break;
            }
            case RESOURCE: {
                paramsPropertyHolder = ((RestRequestInterface)this.getRequest()).getResource().getParams();
            }
        }
        if (paramsPropertyHolder != null) {
            paramsPropertyHolder.addProperty(name);
            RestParamProperty addedParameter = paramsPropertyHolder.getProperty(name);
            addedParameter.addPropertyChangeListener(this.restParamPropertyChangeListener);
            addedParameter.setValue(value);
            addedParameter.setDefaultValue(value);
            addedParameter.setStyle(style);
            ((RestRequestInterface)this.getRequest()).getParams().getProperty(name).setValue(requestLevelValue);
        }
        this.addPropertyChangeListenerToResource((RestRequestInterface)this.getRequest());
    }

    private void removePropertyFromLevel(String propertytName, NewRestResourceActionBase.ParamLocation location) {
        switch (location) {
            case METHOD: {
                ((RestRequestInterface)this.getRequest()).getRestMethod().removeProperty(propertytName);
                break;
            }
            case RESOURCE: {
                ((RestRequestInterface)this.getRequest()).getResource().removeProperty(propertytName);
            }
        }
    }

    private class EndpointChangeListener
    implements PropertyChangeListener {
        private EndpointChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object currentEndpoint;
            if (evt.getPropertyName().equals(Interface.ENDPOINT_PROPERTY) && (currentEndpoint = AbstractRestRequestDesktopPanel.this.getEndpointsModel().getSelectedItem()) != null && currentEndpoint.equals(evt.getOldValue())) {
                AbstractRestRequestDesktopPanel.this.getEndpointsModel().setSelectedItem(evt.getNewValue());
            }
        }
    }

    private class RestParamPropertyChangeListener
    implements PropertyChangeListener {
        private RestParamPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                if (evt.getPropertyName().equals("style")) {
                    RestParamProperty source = (RestParamProperty)evt.getSource();
                    ((AbstractModelItem)source.getModelItem()).notifyPropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            }
            catch (XmlValueDisconnectedException xmlValueDisconnectedException) {
                // empty catch block
            }
            AbstractRestRequestDesktopPanel.this.updateUiValues();
        }
    }

    private class InternalTestPropertyListener
    extends TestPropertyListenerAdapter {
        private InternalTestPropertyListener() {
        }

        @Override
        public void propertyValueChanged(String name, String oldValue, String newValue) {
            AbstractRestRequestDesktopPanel.this.updateUiValues();
        }

        @Override
        public void propertyAdded(String name) {
            AbstractRestRequestDesktopPanel.this.updateUiValues();
            RestParamProperty property = ((RestRequestInterface)AbstractRestRequestDesktopPanel.this.getRequest()).getParams().getProperty(name);
            property.addPropertyChangeListener(AbstractRestRequestDesktopPanel.this.restParamPropertyChangeListener);
        }

        @Override
        public void propertyRemoved(String name) {
            AbstractRestRequestDesktopPanel.this.updateUiValues();
        }

        @Override
        public void propertyRenamed(String oldName, String newName) {
            AbstractRestRequestDesktopPanel.this.updateUiValues();
        }
    }
}

