/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.mock;

import com.eviware.soapui.impl.rest.mock.RestMockResponse;
import com.eviware.soapui.impl.rest.panels.mock.CompleteHttpStatus;
import com.eviware.soapui.impl.rest.panels.mock.HttpStatusCodeComboBoxModel;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.http.MediaType;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.MockResponseXmlDocument;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.support.MediaTypeComboBox;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.editor.inspectors.httpheaders.HttpHeadersInspector;
import com.eviware.soapui.support.editor.inspectors.httpheaders.MockResponseHeadersModel;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import com.eviware.soapui.ui.support.AbstractMockResponseDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RestMockResponseDesktopPanel
extends AbstractMockResponseDesktopPanel<RestMockResponse, MockResponse> {
    public RestMockResponseDesktopPanel(MockResponse mockResponse) {
        super((RestMockResponse)mockResponse);
        this.init(mockResponse);
    }

    @Override
    public JComponent addTopEditorPanel() {
        JPanel topEditorPanel = new JPanel(new BorderLayout());
        topEditorPanel.add((Component)this.createHttpStatusPanel(), "North");
        topEditorPanel.add((Component)this.createHeaderInspector(), "Center");
        return topEditorPanel;
    }

    @Override
    protected Component addBottomEditorPanel(AbstractMockResponseDesktopPanel.MockResponseMessageEditor responseEditor) {
        JPanel bottomEditorPanel = new JPanel(new BorderLayout());
        bottomEditorPanel.add((Component)this.createMediaTypeCombo(), "North");
        bottomEditorPanel.add((Component)responseEditor, "Center");
        return bottomEditorPanel;
    }

    @Override
    public boolean hasTopEditorPanel() {
        return true;
    }

    private JComponent createHttpStatusPanel() {
        return this.createPanelWithLabel("Http Status Code: ", this.createStatusCodeCombo());
    }

    @Override
    protected AbstractMockResponseDesktopPanel.MockResponseMessageEditor buildResponseEditor() {
        MockResponseXmlDocument documentContent = new MockResponseXmlDocument((MockResponse)this.getMockResponse());
        AbstractMockResponseDesktopPanel.MockResponseMessageEditor mockResponseMessageEditor = new AbstractMockResponseDesktopPanel.MockResponseMessageEditor(this, documentContent);
        SyntaxEditorUtil.setMediaType(mockResponseMessageEditor.getInputArea(), ((RestMockResponse)this.getModelItem()).getMediaType());
        return mockResponseMessageEditor;
    }

    private JComponent createMediaTypeCombo() {
        MediaTypeComboBox mediaTypeComboBox = new MediaTypeComboBox((MediaType)this.getModelItem());
        mediaTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SyntaxEditorUtil.setMediaType(RestMockResponseDesktopPanel.this.getResponseEditor().getInputArea(), e.getItem().toString());
            }
        });
        JComponent innerPanel = this.createPanelWithLabel("Content | Media type: ", mediaTypeComboBox);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 0));
        outerPanel.add(innerPanel);
        outerPanel.add(Box.createHorizontalGlue());
        outerPanel.add(UISupport.createFormButton(new ShowOnlineHelpAction("http://www.soapui.org/REST-Service-Mocking/mock-response-editor-body.html")));
        return outerPanel;
    }

    private JComponent createPanelWithLabel(String labelText, Component rightSideComponent) {
        JPanel innerPanel = new JPanel(new FlowLayout(0));
        innerPanel.add(new JLabel(labelText));
        innerPanel.add(rightSideComponent);
        return innerPanel;
    }

    private JComboBox createStatusCodeCombo() {
        HttpStatusCodeComboBoxModel httpStatusCodeComboBoxModel = new HttpStatusCodeComboBoxModel();
        final JComboBox statusCodeCombo = new JComboBox(httpStatusCodeComboBoxModel);
        statusCodeCombo.setSelectedItem(CompleteHttpStatus.from(((RestMockResponse)this.getModelItem()).getResponseHttpStatus()));
        statusCodeCombo.setToolTipText("Set desired HTTP status code");
        statusCodeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((RestMockResponse)RestMockResponseDesktopPanel.this.getModelItem()).setResponseHttpStatus(((CompleteHttpStatus)statusCodeCombo.getSelectedItem()).getStatusCode());
            }
        });
        return statusCodeCombo;
    }

    private JComponent createHeaderInspector() {
        MockResponseHeadersModel model = new MockResponseHeadersModel((MockResponse)this.getModelItem());
        HttpHeadersInspector inspector = new HttpHeadersInspector(model);
        JComponent component = inspector.getComponent();
        return component;
    }

    @Override
    public boolean hasRequestEditor() {
        return false;
    }

    @Override
    public String getHelpUrl() {
        return "http://www.soapui.org/REST-Service-Mocking/mock-response-editor.html";
    }
}

