/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.mock;

import com.eviware.soapui.config.RESTMockActionConfig;
import com.eviware.soapui.config.RESTMockServiceConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.mock.RestMockAction;
import com.eviware.soapui.impl.rest.mock.RestMockDispatcher;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.AbstractMockService;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockDispatcher;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.project.Project;
import java.util.ArrayList;
import java.util.List;

public class RestMockService
extends AbstractMockService<RestMockAction, RESTMockServiceConfig> {
    public static final String ICON_NAME = "/restMockService.gif";
    public static final String STRING_ID = "REST";

    @Override
    public String getStringID() {
        return STRING_ID;
    }

    public RestMockService(Project project, RESTMockServiceConfig config) {
        super(config, (ModelItem)project, ICON_NAME);
        List<RESTMockActionConfig> restActionConfigList = config.getRestMockActionList();
        for (RESTMockActionConfig restActionConfig : restActionConfigList) {
            RestMockAction restMockAction = new RestMockAction(this, restActionConfig);
            this.addMockOperation(restMockAction);
        }
        if (!((RESTMockServiceConfig)this.getConfig()).isSetProperties()) {
            ((RESTMockServiceConfig)this.getConfig()).addNewProperties();
        }
        this.setPropertiesConfig(config.getProperties());
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public MockDispatcher createDispatcher(WsdlMockRunContext mockContext) {
        return new RestMockDispatcher(this, mockContext);
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getMockOperationList();
    }

    public RestMockAction addNewMockAction(RestRequest restRequest) {
        RestMockAction mockAction = this.addEmptyMockAction(restRequest.getMethod(), RestUtils.getExpandedPath(restRequest.getPath(), restRequest.getParams(), restRequest));
        mockAction.setResource(restRequest.getResource());
        return mockAction;
    }

    public RestMockAction addEmptyMockAction(RestRequestInterface.HttpMethod method, String path) {
        RESTMockActionConfig config = ((RESTMockServiceConfig)this.getConfig()).addNewRestMockAction();
        String slashifiedPath = this.slashify(path);
        String name = path;
        config.setName(name);
        config.setMethod(method.name());
        config.setResourcePath(slashifiedPath);
        RestMockAction restMockAction = new RestMockAction(this, config);
        this.addMockOperation(restMockAction);
        this.fireMockOperationAdded(restMockAction);
        return restMockAction;
    }

    public MockOperation findOrCreateNewOperation(RestRequest restRequest) {
        String expandedPath = RestUtils.getExpandedPath(restRequest.getPath(), restRequest.getParams(), restRequest);
        MockOperation matchedOperation = this.findMatchingOperationWithExactPath(expandedPath, restRequest.getMethod());
        if (matchedOperation == null) {
            matchedOperation = this.addNewMockAction(restRequest);
        }
        return matchedOperation;
    }

    protected MockOperation findBestMatchedOperation(String pathToFind, RestRequestInterface.HttpMethod verbToFind) {
        boolean includePartialMatch = true;
        return this.findMatchedOperation(pathToFind, verbToFind, includePartialMatch);
    }

    protected MockOperation findMatchingOperationWithExactPath(String pathToFind, RestRequestInterface.HttpMethod verbToFind) {
        boolean dontIncludePartialMatch = false;
        return this.findMatchedOperation(pathToFind, verbToFind, dontIncludePartialMatch);
    }

    private MockOperation findMatchedOperation(String pathToFind, RestRequestInterface.HttpMethod verbToFind, boolean includePartialMatch) {
        MockOperation bestMatchedOperation = null;
        for (MockOperation operation : this.getMockOperationList()) {
            String operationPath = ((RestMockAction)operation).getResourcePath();
            RestRequestInterface.HttpMethod operationVerb = ((RestMockAction)operation).getMethod();
            boolean matchesPath = operationPath.equals(pathToFind);
            boolean matchesVerb = verbToFind == operationVerb;
            boolean matchesPathPartially = pathToFind.startsWith(operationPath);
            if (matchesPath && matchesVerb) {
                return operation;
            }
            if (!includePartialMatch || !matchesPathPartially || !matchesVerb) continue;
            bestMatchedOperation = this.getBestMatchedOperation(bestMatchedOperation, operation, operationPath);
        }
        return bestMatchedOperation;
    }

    private MockOperation getBestMatchedOperation(MockOperation currentBestMatchedOperation, MockOperation operation, String operationPath) {
        MockOperation bestMatchedOperation = currentBestMatchedOperation;
        if (bestMatchedOperation == null || this.foundBetterMatch((RestMockAction)bestMatchedOperation, operationPath)) {
            bestMatchedOperation = operation;
        }
        return bestMatchedOperation;
    }

    private boolean foundBetterMatch(RestMockAction bestMatchedOperation, String operationPath) {
        return bestMatchedOperation.getResourcePath().length() < operationPath.length();
    }

    @Override
    public boolean canIAddAMockOperation(RestMockAction mockOperation) {
        return ((RESTMockServiceConfig)this.getConfig()).getRestMockActionList().contains(mockOperation.getConfig());
    }

    @Override
    public MockOperation addNewMockOperation(Operation operation) {
        return this.addNewMockOperationsFromResource((RestResource)operation).get(0);
    }

    public List<MockOperation> addNewMockOperationsFromResource(RestResource restResource) {
        ArrayList<MockOperation> actions = new ArrayList<MockOperation>();
        String path = RestUtils.getExpandedPath(restResource.getFullPath(), restResource.getParams(), restResource);
        if (restResource.getRestMethodCount() < 1) {
            actions.add(this.addEmptyMockAction(RestRequestInterface.HttpMethod.GET, path));
        }
        for (RestMethod restMethod : restResource.getRestMethodList()) {
            actions.add(this.addEmptyMockAction(restMethod.getMethod(), path));
        }
        return actions;
    }

    private String slashify(String path) {
        if (!path.startsWith("/") && !path.isEmpty()) {
            return "/" + path;
        }
        return path;
    }

    @Override
    public String getHelpUrl() {
        return "http://www.soapui.org/REST-Service-Mocking/mock-service-editor.html";
    }
}

