/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2ClientFacade;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2Exception;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2ParameterValidator;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2Parameters;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2TokenExtractor;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.StringEntity;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

public class OltuOAuth2ClientFacade
implements OAuth2ClientFacade {
    @Override
    public void requestAccessToken(OAuth2Profile profile) throws OAuth2Exception {
        try {
            OAuth2Parameters parameters = this.buildParametersFrom(profile);
            OAuth2ParameterValidator.validate(parameters);
            this.getOAuth2TokenExtractor().extractAccessToken(parameters);
        }
        catch (OAuthSystemException e) {
            this.logAndThrowOAuth2Exception((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            this.logAndThrowOAuth2Exception(e);
        }
        catch (URISyntaxException e) {
            this.logAndThrowOAuth2Exception(e);
        }
    }

    protected OAuth2TokenExtractor getOAuth2TokenExtractor() {
        return new OAuth2TokenExtractor();
    }

    @Override
    public void refreshAccessToken(OAuth2Profile profile) throws Exception {
        OAuth2Parameters parameters = this.buildParametersFrom(profile);
        OAuth2ParameterValidator.validateRequiredStringValue(parameters.refreshToken, "refresh token");
        OAuth2ParameterValidator.validateRequiredStringValue(parameters.clientId, "client ID");
        OAuth2ParameterValidator.validateRequiredStringValue(parameters.clientSecret, "client secret");
        this.getOAuth2TokenExtractor().refreshAccessToken(parameters);
    }

    @Override
    public void applyAccessToken(OAuth2Profile profile, HttpRequestBase request, String requestContent) {
        String uri = request.getURI().getPath();
        OAuthBearerClientRequest oAuthClientRequest = new OAuthBearerClientRequest(uri).setAccessToken(profile.getAccessToken());
        try {
            switch (profile.getAccessTokenPosition()) {
                case QUERY: {
                    this.appendAccessTokenToQuery(request, oAuthClientRequest);
                    break;
                }
                case BODY: {
                    this.appendAccessTokenToBody(request, oAuthClientRequest);
                    break;
                }
                default: {
                    this.appendAccessTokenToHeader(request, oAuthClientRequest);
                    break;
                }
            }
        }
        catch (OAuthSystemException e) {
            SoapUI.logError(e);
        }
    }

    private OAuth2Parameters buildParametersFrom(OAuth2Profile profile) {
        return new OAuth2Parameters(profile);
    }

    private void logAndThrowOAuth2Exception(Exception e) throws OAuth2Exception {
        SoapUI.logError(e, "Failed to create the authorization URL");
        throw new OAuth2Exception(e);
    }

    private void appendAccessTokenToBody(HttpRequestBase request, OAuthBearerClientRequest oAuthClientRequest) throws OAuthSystemException {
        try {
            HttpEntity httpEntity;
            if (request instanceof HttpEntityEnclosingRequest && (httpEntity = ((HttpEntityEnclosingRequest)request).getEntity()) == null) {
                String accessTokenParameter = this.getQueryStringFromOAuthClientRequest(oAuthClientRequest);
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new StringEntity(accessTokenParameter));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthSystemException((Throwable)e);
        }
    }

    private void appendAccessTokenToQuery(HttpRequestBase request, OAuthBearerClientRequest oAuthClientRequest) throws OAuthSystemException {
        String queryString = this.getQueryStringFromOAuthClientRequest(oAuthClientRequest);
        URI oldUri = request.getURI();
        String requestQueryString = oldUri.getQuery() != null ? oldUri.getQuery() + "&" + queryString : queryString;
        try {
            request.setURI(URIUtils.createURI((String)oldUri.getScheme(), (String)oldUri.getHost(), (int)oldUri.getPort(), (String)oldUri.getRawPath(), (String)requestQueryString, (String)oldUri.getFragment()));
        }
        catch (URISyntaxException e) {
            throw new OAuthSystemException((Throwable)e);
        }
    }

    private String getQueryStringFromOAuthClientRequest(OAuthBearerClientRequest oAuthClientRequest) throws OAuthSystemException {
        String uriWithAccessToken = oAuthClientRequest.buildQueryMessage().getLocationUri();
        return uriWithAccessToken.split("\\?")[1];
    }

    private void appendAccessTokenToHeader(HttpRequestBase request, OAuthBearerClientRequest oAuthClientRequest) throws OAuthSystemException {
        Map oAuthHeaders = oAuthClientRequest.buildHeaderMessage().getHeaders();
        request.removeHeaders("Authorization");
        request.addHeader("Authorization", (String)oAuthHeaders.get("Authorization"));
    }
}

