/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.actions.oauth.BrowserListener;
import com.eviware.soapui.impl.rest.actions.oauth.BrowserListenerAdapter;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2AccessTokenResponse;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2Parameters;
import com.eviware.soapui.impl.rest.actions.oauth.UserBrowserFacade;
import com.eviware.soapui.impl.rest.actions.oauth.WebViewUserBrowserFacade;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.TimeUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.token.OAuthToken;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.httpclient4.HttpClient4;

public class OAuth2TokenExtractor {
    public static final String CODE = "code";
    public static final String TITLE = "<TITLE>";
    public static final String TOKEN = "token";
    public static final String ACCESS_TOKEN = "access_token";
    protected List<BrowserListener> browserListeners = new ArrayList<BrowserListener>();

    public void extractAccessToken(OAuth2Parameters parameters) throws OAuthSystemException, MalformedURLException, URISyntaxException {
        switch (parameters.getOAuth2Flow()) {
            case IMPLICIT_GRANT: {
                this.extractAccessTokenForImplicitGrantFlow(parameters);
                break;
            }
            default: {
                this.extractAccessTokenForAuthorizationCodeGrantFlow(parameters);
            }
        }
    }

    void extractAccessTokenForAuthorizationCodeGrantFlow(final OAuth2Parameters parameters) throws URISyntaxException, MalformedURLException, OAuthSystemException {
        final UserBrowserFacade browserFacade = this.getBrowserFacade();
        this.addBrowserInteractionHandler(browserFacade, parameters);
        this.addExternalListeners(browserFacade);
        browserFacade.addBrowserListener(new BrowserListenerAdapter(){

            @Override
            public void locationChanged(String newLocation) {
                OAuth2TokenExtractor.this.getAccessTokenAndSaveToProfile(browserFacade, parameters, OAuth2TokenExtractor.this.extractAuthorizationCodeFromForm(OAuth2TokenExtractor.this.extractFormData(newLocation), OAuth2TokenExtractor.CODE));
            }

            @Override
            public void contentChanged(String newContent) {
                int titlePosition = newContent.indexOf(OAuth2TokenExtractor.TITLE);
                if (titlePosition != -1) {
                    String title = newContent.substring(titlePosition + OAuth2TokenExtractor.TITLE.length(), newContent.indexOf("</TITLE>"));
                    OAuth2TokenExtractor.this.getAccessTokenAndSaveToProfile(browserFacade, parameters, OAuth2TokenExtractor.this.extractAuthorizationCodeFromTitle(title));
                }
            }

            @Override
            public void browserClosed() {
                super.browserClosed();
                if (!parameters.isAccessTokenRetrivedFromServer()) {
                    OAuth2TokenExtractor.this.setRetrievedCanceledStatus(parameters);
                }
            }
        });
        browserFacade.open(new URI(this.createAuthorizationURL(parameters, CODE)).toURL());
        parameters.waitingForAuthorization();
    }

    void extractAccessTokenForImplicitGrantFlow(final OAuth2Parameters parameters) throws OAuthSystemException, URISyntaxException, MalformedURLException {
        final UserBrowserFacade browserFacade = this.getBrowserFacade();
        this.addBrowserInteractionHandler(browserFacade, parameters);
        this.addExternalListeners(browserFacade);
        browserFacade.addBrowserListener(new BrowserListenerAdapter(){

            @Override
            public void locationChanged(String newLocation) {
                String accessToken = OAuth2TokenExtractor.this.extractAuthorizationCodeFromForm(OAuth2TokenExtractor.this.extractFormData(newLocation), OAuth2TokenExtractor.ACCESS_TOKEN);
                if (!StringUtils.isNullOrEmpty(accessToken)) {
                    parameters.setAccessTokenInProfile(accessToken);
                    parameters.setRefreshTokenInProfile(null);
                    parameters.setAccessTokenExpirationTimeInProfile(0L);
                    parameters.setAccessTokenIssuedTimeInProfile(TimeUtils.getCurrentTimeInSeconds());
                    browserFacade.close();
                }
            }

            @Override
            public void browserClosed() {
                super.browserClosed();
                if (!parameters.isAccessTokenRetrivedFromServer()) {
                    OAuth2TokenExtractor.this.setRetrievedCanceledStatus(parameters);
                }
            }
        });
        browserFacade.open(new URI(this.createAuthorizationURL(parameters, TOKEN)).toURL());
        parameters.waitingForAuthorization();
    }

    void refreshAccessToken(OAuth2Parameters parameters) throws OAuthProblemException, OAuthSystemException {
        OAuthClientRequest accessTokenRequest = OAuthClientRequest.tokenLocation((String)parameters.accessTokenUri).setGrantType(GrantType.REFRESH_TOKEN).setClientId(parameters.clientId).setClientSecret(parameters.clientSecret).setRefreshToken(parameters.refreshToken).buildBodyMessage();
        OAuthClient oAuthClient = this.getOAuthClient();
        OAuthToken oAuthToken = ((OAuthJSONAccessTokenResponse)oAuthClient.accessToken(accessTokenRequest, OAuthJSONAccessTokenResponse.class)).getOAuthToken();
        parameters.applyRetrievedAccessToken(oAuthToken.getAccessToken());
        parameters.setAccessTokenIssuedTimeInProfile(TimeUtils.getCurrentTimeInSeconds());
    }

    public void addBrowserListener(BrowserListener listener) {
        this.browserListeners.add(listener);
    }

    protected OAuthClient getOAuthClient() {
        return new OAuthClient((HttpClient)new HttpClient4((org.apache.http.client.HttpClient)HttpClientSupport.getHttpClient()));
    }

    protected UserBrowserFacade getBrowserFacade() {
        return new WebViewUserBrowserFacade();
    }

    private void setRetrievedCanceledStatus(OAuth2Parameters parameters) {
        parameters.retrivalCanceled();
    }

    private void addExternalListeners(UserBrowserFacade browserFacade) {
        for (BrowserListener browserListener : this.browserListeners) {
            browserFacade.addBrowserListener(browserListener);
        }
    }

    private void addBrowserInteractionHandler(UserBrowserFacade browserFacade, OAuth2Parameters parameters) {
        if (parameters.getJavaScripts().isEmpty()) {
            return;
        }
        browserFacade.addBrowserListener(new BrowserInteractionMonitor(browserFacade, parameters.getJavaScripts()));
    }

    private String createAuthorizationURL(OAuth2Parameters parameters, String responseType) throws OAuthSystemException {
        return OAuthClientRequest.authorizationLocation((String)parameters.authorizationUri).setClientId(parameters.clientId).setResponseType(responseType).setScope(parameters.scope).setRedirectURI(parameters.redirectUri).buildQueryMessage().getLocationUri();
    }

    private String extractFormData(String url) {
        int questionMarkIndex = url.indexOf(63);
        if (questionMarkIndex != -1) {
            return url.substring(questionMarkIndex + 1);
        }
        int hashIndex = url.indexOf("#");
        if (hashIndex != -1) {
            return url.substring(hashIndex + 1);
        }
        return "";
    }

    private String extractAuthorizationCodeFromTitle(String title) {
        if (title.contains("code=")) {
            return title.substring(title.indexOf("code=") + 5);
        }
        return null;
    }

    private String extractAuthorizationCodeFromForm(String formData, String parameterName) {
        return (String)OAuthUtils.decodeForm((String)formData).get(parameterName);
    }

    private void getAccessTokenAndSaveToProfile(UserBrowserFacade browserFacade, OAuth2Parameters parameters, String authorizationCode) {
        if (authorizationCode != null) {
            try {
                parameters.receivedAuthorizationCode();
                OAuthClientRequest accessTokenRequest = OAuthClientRequest.tokenLocation((String)parameters.accessTokenUri).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(parameters.clientId).setClientSecret(parameters.clientSecret).setRedirectURI(parameters.redirectUri).setCode(authorizationCode).buildBodyMessage();
                OAuthToken token = ((OAuth2AccessTokenResponse)this.getOAuthClient().accessToken(accessTokenRequest, OAuth2AccessTokenResponse.class)).getOAuthToken();
                if (token != null && token.getAccessToken() != null) {
                    parameters.setAccessTokenInProfile(token.getAccessToken());
                    parameters.setRefreshTokenInProfile(token.getRefreshToken());
                    if (token.getExpiresIn() != null) {
                        parameters.setAccessTokenExpirationTimeInProfile(token.getExpiresIn());
                    }
                    parameters.setAccessTokenIssuedTimeInProfile(TimeUtils.getCurrentTimeInSeconds());
                    browserFacade.close();
                }
            }
            catch (OAuthSystemException e) {
                SoapUI.logError(e);
            }
            catch (OAuthProblemException e) {
                SoapUI.logError(e);
            }
        }
    }

    private class BrowserInteractionMonitor
    extends BrowserListenerAdapter {
        private final List<String> javaScripts;
        int pageIndex = 0;
        private UserBrowserFacade browserFacade;

        public BrowserInteractionMonitor(UserBrowserFacade browserFacade, List<String> javaScripts) {
            this.browserFacade = browserFacade;
            this.javaScripts = javaScripts;
        }

        @Override
        public void contentChanged(String newContent) {
            if (this.javaScripts.size() > this.pageIndex) {
                String script = this.javaScripts.get(this.pageIndex);
                try {
                    this.browserFacade.executeJavaScript(script);
                }
                catch (Exception e) {
                    SoapUI.log.warn((Object)("Error when running JavaScript [" + script + "]: " + e.getMessage()));
                }
                ++this.pageIndex;
            }
        }
    }
}

