/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.config.AccessTokenPositionConfig;
import com.eviware.soapui.config.AccessTokenStatusConfig;
import com.eviware.soapui.config.OAuth2FlowConfig;
import com.eviware.soapui.config.OAuth2ProfileConfig;
import com.eviware.soapui.config.RefreshAccessTokenMethodConfig;
import com.eviware.soapui.config.StringListConfig;
import com.eviware.soapui.config.TimeUnitConfig;
import com.eviware.soapui.impl.rest.OAuth2ProfileContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class OAuth2Profile
implements PropertyExpansionContainer {
    public static final String CLIENT_ID_PROPERTY = "clientID";
    public static final String CLIENT_SECRET_PROPERTY = "clientSecret";
    public static final String AUTHORIZATION_URI_PROPERTY = "authorizationURI";
    public static final String ACCESS_TOKEN_URI_PROPERTY = "accessTokenURI";
    public static final String REDIRECT_URI_PROPERTY = "redirectURI";
    public static final String ACCESS_TOKEN_PROPERTY = "accessToken";
    public static final String REFRESH_TOKEN_PROPERTY = "refreshToken";
    public static final String SCOPE_PROPERTY = "scope";
    public static final String ACCESS_TOKEN_STATUS_PROPERTY = "accessTokenStatus";
    public static final String ACCESS_TOKEN_POSITION_PROPERTY = "accessTokenPosition";
    public static final String ACCESS_TOKEN_EXPIRATION_TIME = "accessTokenExpirationTime";
    public static final String ACCESS_TOKEN_ISSUED_TIME = "accessTokenIssuedTime";
    public static final String MANUAL_ACCESS_TOKEN_EXPIRATION_TIME = "manualAccessTokenExpirationTime";
    public static final String USE_MANUAL_ACCESS_TOKEN_EXPIRATION_TIME = "useManualAccessTokenExpirationTime";
    public static final String REFRESH_ACCESS_TOKEN_METHOD_PROPERTY = "refreshAccessTokenMethod";
    public static final String OAUTH2_FLOW_PROPERTY = "oAuth2Flow";
    public static final String JAVA_SCRIPTS_PROPERTY = "javaScripts";
    public static final String MANUAL_ACCESS_TOKEN_EXPIRATION_TIME_UNIT_PROPERTY = "manualAccessTokenExpirationTimeUnit";
    private final OAuth2ProfileContainer oAuth2ProfileContainer;
    private final OAuth2ProfileConfig configuration;
    private final PropertyChangeSupport pcs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAccessTokenStatus(AccessTokenStatus accessTokenStatus, int timeout) {
        int timeLeft = timeout;
        while (this.getAccessTokenStatus() != accessTokenStatus && timeLeft > 0) {
            long startTime = System.currentTimeMillis();
            try {
                OAuth2Profile oAuth2Profile = this;
                synchronized (oAuth2Profile) {
                    this.wait(timeLeft);
                }
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            timeLeft = (int)((long)timeLeft - (System.currentTimeMillis() - startTime));
        }
    }

    public OAuth2Profile(OAuth2ProfileContainer oAuth2ProfileContainer, OAuth2ProfileConfig configuration) {
        this.oAuth2ProfileContainer = oAuth2ProfileContainer;
        this.configuration = configuration;
        this.pcs = new PropertyChangeSupport(this);
        this.setDefaultAccessTokenPosition();
        this.setDefaultRefreshMethod();
        this.setDefaultAccessTokenStatus();
    }

    public String getName() {
        if (StringUtils.isEmpty((String)this.configuration.getName())) {
            this.configuration.setName("OAuth 2 - Profile 1");
        }
        return this.configuration.getName();
    }

    public void setName(String newName) {
        this.configuration.setName(newName);
    }

    public boolean hasAutomationJavaScripts() {
        List<String> javaScripts = this.getAutomationJavaScripts();
        return javaScripts != null && !javaScripts.isEmpty();
    }

    public void applyRetrievedAccessToken(String accessToken) {
        this.doSetAccessToken(accessToken);
        this.setAccessTokenStatus(AccessTokenStatus.RETRIEVED_FROM_SERVER);
    }

    public String getAccessToken() {
        return this.configuration.getAccessToken();
    }

    public void setAccessToken(String accessToken) {
        if (this.doSetAccessToken(accessToken)) {
            this.setAccessTokenStatus(AccessTokenStatus.ENTERED_MANUALLY);
        }
    }

    public void setOAuth2Flow(OAuth2Flow oauth2Flow) {
        OAuth2Flow existingFlow = this.getOAuth2Flow();
        if (!oauth2Flow.equals((Object)existingFlow)) {
            this.configuration.setOAuth2Flow(OAuth2FlowConfig.Enum.forString(oauth2Flow.name()));
            this.pcs.firePropertyChange(OAUTH2_FLOW_PROPERTY, (Object)existingFlow, (Object)oauth2Flow);
        }
    }

    public OAuth2Flow getOAuth2Flow() {
        if (this.configuration.getOAuth2Flow() == null) {
            this.configuration.setOAuth2Flow(OAuth2FlowConfig.AUTHORIZATION_CODE_GRANT);
        }
        return OAuth2Flow.valueOf(this.configuration.getOAuth2Flow().toString());
    }

    public String getRefreshToken() {
        return this.configuration.getRefreshToken();
    }

    public void setRefreshToken(String refreshToken) {
        String oldValue = this.configuration.getRefreshToken();
        if (!StringUtils.equals((String)oldValue, (String)refreshToken)) {
            this.configuration.setRefreshToken(refreshToken);
            this.pcs.firePropertyChange(REFRESH_TOKEN_PROPERTY, oldValue, refreshToken);
        }
    }

    private boolean doSetAccessToken(String accessToken) {
        String newValue;
        String oldValue = this.configuration.getAccessToken();
        String string = newValue = accessToken == null ? null : accessToken.trim();
        if (!StringUtils.equals((String)oldValue, (String)newValue)) {
            this.configuration.setAccessToken(newValue);
            this.pcs.firePropertyChange(ACCESS_TOKEN_PROPERTY, oldValue, newValue);
            return true;
        }
        return false;
    }

    public String getAuthorizationURI() {
        return this.configuration.getAuthorizationURI();
    }

    public void setAuthorizationURI(String authorizationURI) {
        String newValue;
        String oldValue = this.configuration.getAuthorizationURI();
        if (!StringUtils.equals((String)oldValue, (String)(newValue = this.nullSafeTrim(authorizationURI)))) {
            this.configuration.setAuthorizationURI(newValue);
            this.pcs.firePropertyChange(AUTHORIZATION_URI_PROPERTY, oldValue, newValue);
        }
    }

    private String nullSafeTrim(String inputString) {
        return inputString == null ? null : inputString.trim();
    }

    public String getClientID() {
        return this.configuration.getClientID();
    }

    public void setClientID(String clientID) {
        String newValue;
        String oldValue = this.configuration.getClientID();
        if (!StringUtils.equals((String)oldValue, (String)(newValue = this.nullSafeTrim(clientID)))) {
            this.configuration.setClientID(newValue);
            this.pcs.firePropertyChange(CLIENT_ID_PROPERTY, oldValue, newValue);
        }
    }

    public String getClientSecret() {
        return this.configuration.getClientSecret();
    }

    public void setClientSecret(String clientSecret) {
        String oldValue = this.configuration.getClientSecret();
        if (!StringUtils.equals((String)oldValue, (String)clientSecret)) {
            this.configuration.setClientSecret(clientSecret);
            this.pcs.firePropertyChange(CLIENT_SECRET_PROPERTY, oldValue, clientSecret);
        }
    }

    public String getRedirectURI() {
        return this.configuration.getRedirectURI();
    }

    public void setRedirectURI(String redirectURI) {
        String oldValue = this.configuration.getRedirectURI();
        if (!StringUtils.equals((String)oldValue, (String)redirectURI)) {
            this.configuration.setRedirectURI(redirectURI);
            this.pcs.firePropertyChange(REDIRECT_URI_PROPERTY, oldValue, redirectURI);
        }
    }

    public String getScope() {
        return this.configuration.getScope();
    }

    public void setScope(String scope) {
        String oldValue = this.configuration.getScope();
        if (!StringUtils.equals((String)oldValue, (String)scope)) {
            this.configuration.setScope(scope);
            this.pcs.firePropertyChange(SCOPE_PROPERTY, oldValue, scope);
        }
    }

    public OAuth2ProfileConfig getConfiguration() {
        return this.configuration;
    }

    public String getAccessTokenURI() {
        return this.configuration.getAccessTokenURI();
    }

    public void setAccessTokenURI(String accessTokenURI) {
        String newValue;
        String oldValue = this.configuration.getAccessTokenURI();
        if (!StringUtils.equals((String)oldValue, (String)(newValue = this.nullSafeTrim(accessTokenURI)))) {
            this.configuration.setAccessTokenURI(newValue);
            this.pcs.firePropertyChange(ACCESS_TOKEN_URI_PROPERTY, oldValue, newValue);
        }
    }

    public AccessTokenStatus getAccessTokenStatus() {
        return this.getSavedAccessTokenStatusEnum(this.configuration.getAccessTokenStatus());
    }

    public void setAccessTokenStatus(AccessTokenStatus newStatus) {
        AccessTokenStatus oldStatus = this.getSavedAccessTokenStatusEnum(this.configuration.getAccessTokenStatus());
        if (newStatus == oldStatus) {
            return;
        }
        this.saveAccessTokenStatusEnum(newStatus, this.configuration);
        if (this.isAStartingStatus(newStatus)) {
            this.setAccessTokenStartingStatus(newStatus);
        }
        this.pcs.firePropertyChange(ACCESS_TOKEN_STATUS_PROPERTY, (Object)oldStatus, (Object)newStatus);
    }

    public AccessTokenStatus getAccessTokenStartingStatus() {
        return this.getSavedAccessTokenStartingStatusEnum(this.configuration.getAccessTokenStartingStatus());
    }

    public void resetAccessTokenStatusToStartingStatus() {
        this.setAccessTokenStatus(this.getAccessTokenStartingStatus());
    }

    public AccessTokenPosition getAccessTokenPosition() {
        return this.getSavedAccessTokenPositionEnum(this.configuration.getAccessTokenPosition());
    }

    public void setAccessTokenPosition(@Nonnull AccessTokenPosition newAccessTokenPosition) {
        Preconditions.checkNotNull((Object)((Object)newAccessTokenPosition));
        AccessTokenPosition oldAccessTokenPosition = this.getSavedAccessTokenPositionEnum(this.configuration.getAccessTokenPosition());
        this.saveAccessTokenPositionEnum(newAccessTokenPosition, this.configuration);
        this.pcs.firePropertyChange(ACCESS_TOKEN_POSITION_PROPERTY, (Object)oldAccessTokenPosition, (Object)newAccessTokenPosition);
    }

    public RefreshAccessTokenMethods getRefreshAccessTokenMethod() {
        return this.getSavedRefreshAccessTokenMethodsEnum(this.configuration.getRefreshAccessTokenMethod());
    }

    public void setRefreshAccessTokenMethod(@Nonnull RefreshAccessTokenMethods newRefreshAccessTokenMethod) {
        Preconditions.checkNotNull((Object)((Object)newRefreshAccessTokenMethod));
        RefreshAccessTokenMethods oldRefreshTokenMethod = this.getSavedRefreshAccessTokenMethodsEnum(this.configuration.getRefreshAccessTokenMethod());
        this.saveRefreshTokenMethodsEnum(newRefreshAccessTokenMethod, this.configuration);
        this.pcs.firePropertyChange(REFRESH_ACCESS_TOKEN_METHOD_PROPERTY, (Object)oldRefreshTokenMethod, (Object)newRefreshAccessTokenMethod);
    }

    public long getAccessTokenExpirationTime() {
        return this.configuration.getAccessTokenExpirationTime();
    }

    public void setAccessTokenExpirationTime(long newExpirationTime) {
        long oldExpirationTime = this.configuration.getAccessTokenExpirationTime();
        if (oldExpirationTime != newExpirationTime) {
            this.configuration.setAccessTokenExpirationTime(newExpirationTime);
            this.pcs.firePropertyChange(ACCESS_TOKEN_EXPIRATION_TIME, oldExpirationTime, newExpirationTime);
        }
    }

    public long getAccessTokenIssuedTime() {
        return this.configuration.getAccessTokenIssuedTime();
    }

    public void setAccessTokenIssuedTime(long newIssuedTime) {
        long oldIssuedTime = this.configuration.getAccessTokenIssuedTime();
        if (oldIssuedTime != newIssuedTime) {
            this.configuration.setAccessTokenIssuedTime(newIssuedTime);
            this.pcs.firePropertyChange(ACCESS_TOKEN_ISSUED_TIME, oldIssuedTime, newIssuedTime);
        }
    }

    public String getManualAccessTokenExpirationTime() {
        return this.configuration.getManualAccessTokenExpirationTime();
    }

    public void setManualAccessTokenExpirationTime(@Nonnull String newExpirationTime) {
        String oldExpirationTime = this.configuration.getManualAccessTokenExpirationTime();
        if (!Objects.equal((Object)oldExpirationTime, (Object)newExpirationTime)) {
            this.configuration.setManualAccessTokenExpirationTime(newExpirationTime);
            this.pcs.firePropertyChange(MANUAL_ACCESS_TOKEN_EXPIRATION_TIME, oldExpirationTime, newExpirationTime);
        }
    }

    public boolean useManualAccessTokenExpirationTime() {
        return this.configuration.getUseManualAccessTokenExpirationTime();
    }

    public void setUseManualAccessTokenExpirationTime(boolean useManual) {
        boolean oldValue = this.configuration.getUseManualAccessTokenExpirationTime();
        if (oldValue != useManual) {
            this.configuration.setUseManualAccessTokenExpirationTime(useManual);
            this.pcs.firePropertyChange(USE_MANUAL_ACCESS_TOKEN_EXPIRATION_TIME, oldValue, useManual);
        }
    }

    public TimeUnitConfig.Enum getManualAccessTokenExpirationTimeUnit() {
        if (this.configuration.getManualAccessTokenExpirationTimeUnit() == null) {
            this.configuration.setManualAccessTokenExpirationTimeUnit(TimeUnitConfig.SECONDS);
        }
        return this.configuration.getManualAccessTokenExpirationTimeUnit();
    }

    public void setManualAccessTokenExpirationTimeUnit(TimeUnitConfig.Enum newValue) {
        TimeUnitConfig.Enum oldValue = this.getManualAccessTokenExpirationTimeUnit();
        if (!((Object)((Object)oldValue)).equals((Object)newValue)) {
            this.configuration.setManualAccessTokenExpirationTimeUnit(newValue);
            this.pcs.firePropertyChange(MANUAL_ACCESS_TOKEN_EXPIRATION_TIME_UNIT_PROPERTY, oldValue.toString(), newValue.toString());
        }
    }

    public boolean shouldReloadAccessTokenAutomatically() {
        return this.getRefreshAccessTokenMethod().equals((Object)RefreshAccessTokenMethods.AUTOMATIC) && (!StringUtils.isEmpty((String)this.getRefreshToken()) || this.hasAutomationJavaScripts());
    }

    public OAuth2ProfileContainer getContainer() {
        return this.oAuth2ProfileContainer;
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.oAuth2ProfileContainer.getProject(), this);
        result.extractAndAddAll(CLIENT_ID_PROPERTY);
        result.extractAndAddAll(CLIENT_SECRET_PROPERTY);
        result.extractAndAddAll(AUTHORIZATION_URI_PROPERTY);
        result.extractAndAddAll(ACCESS_TOKEN_URI_PROPERTY);
        result.extractAndAddAll(REDIRECT_URI_PROPERTY);
        result.extractAndAddAll(ACCESS_TOKEN_PROPERTY);
        result.extractAndAddAll(SCOPE_PROPERTY);
        result.extractAndAddAll(MANUAL_ACCESS_TOKEN_EXPIRATION_TIME);
        return result.toArray();
    }

    public List<String> getAutomationJavaScripts() {
        StringListConfig configurationEntry = this.configuration.getJavaScripts();
        return configurationEntry == null ? Collections.emptyList() : new ArrayList<String>(configurationEntry.getEntryList());
    }

    public void setAutomationJavaScripts(List<String> javaScripts) {
        List<String> oldScripts = this.getAutomationJavaScripts();
        String[] scriptArray = javaScripts.toArray(new String[javaScripts.size()]);
        StringListConfig javaScriptsConfiguration = this.configuration.getJavaScripts();
        if (javaScriptsConfiguration == null) {
            javaScriptsConfiguration = StringListConfig.Factory.newInstance();
        }
        javaScriptsConfiguration.setEntryArray(scriptArray);
        this.configuration.setJavaScripts(javaScriptsConfiguration);
        this.pcs.firePropertyChange(JAVA_SCRIPTS_PROPERTY, oldScripts, javaScripts);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    private void setAccessTokenStartingStatus(@Nonnull AccessTokenStatus startingStatus) {
        Preconditions.checkNotNull((Object)((Object)startingStatus));
        this.saveAccessTokenStartingStatusEnum(startingStatus, this.configuration);
    }

    private boolean isAStartingStatus(AccessTokenStatus newStatus) {
        return newStatus == AccessTokenStatus.ENTERED_MANUALLY || newStatus == AccessTokenStatus.RETRIEVED_FROM_SERVER || newStatus == AccessTokenStatus.EXPIRED;
    }

    private void setDefaultAccessTokenPosition() {
        if (this.getAccessTokenPosition() == null) {
            this.setAccessTokenPosition(AccessTokenPosition.HEADER);
        }
    }

    private void setDefaultRefreshMethod() {
        if (this.getRefreshAccessTokenMethod() == null) {
            this.setRefreshAccessTokenMethod(RefreshAccessTokenMethods.AUTOMATIC);
        }
    }

    private void setDefaultAccessTokenStatus() {
        this.setAccessTokenStatus(AccessTokenStatus.UNKNOWN);
    }

    private AccessTokenStatus getSavedAccessTokenStartingStatusEnum(AccessTokenStatusConfig.Enum persistedEnum) {
        return this.getSavedAccessTokenStatusEnum(persistedEnum);
    }

    private AccessTokenStatus getSavedAccessTokenStatusEnum(AccessTokenStatusConfig.Enum persistedEnum) {
        if (persistedEnum == null) {
            return AccessTokenStatus.UNKNOWN;
        }
        return AccessTokenStatus.valueOf(persistedEnum.toString());
    }

    private AccessTokenPosition getSavedAccessTokenPositionEnum(AccessTokenPositionConfig.Enum persistedEnum) {
        if (persistedEnum == null) {
            return null;
        }
        return AccessTokenPosition.valueOf(persistedEnum.toString());
    }

    private RefreshAccessTokenMethods getSavedRefreshAccessTokenMethodsEnum(RefreshAccessTokenMethodConfig.Enum persistedEnum) {
        if (persistedEnum == null) {
            return null;
        }
        return RefreshAccessTokenMethods.valueOf(persistedEnum.toString());
    }

    private void saveAccessTokenStatusEnum(AccessTokenStatus enumToBePersisted, OAuth2ProfileConfig configuration) {
        configuration.setAccessTokenStatus(AccessTokenStatusConfig.Enum.forString(enumToBePersisted.name()));
    }

    private void saveAccessTokenStartingStatusEnum(AccessTokenStatus enumToBePersisted, OAuth2ProfileConfig configuration) {
        configuration.setAccessTokenStartingStatus(AccessTokenStatusConfig.Enum.forString(enumToBePersisted.name()));
    }

    private void saveAccessTokenPositionEnum(AccessTokenPosition enumToBePersisted, OAuth2ProfileConfig configuration) {
        configuration.setAccessTokenPosition(AccessTokenPositionConfig.Enum.forString(enumToBePersisted.name()));
    }

    private void saveRefreshTokenMethodsEnum(RefreshAccessTokenMethods enumToBePersisted, OAuth2ProfileConfig configuration) {
        configuration.setRefreshAccessTokenMethod(RefreshAccessTokenMethodConfig.Enum.forString(enumToBePersisted.name()));
    }

    public static enum RefreshAccessTokenMethods {
        AUTOMATIC("Automatic"),
        MANUAL("Manual");

        private final String description;

        private RefreshAccessTokenMethods(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum OAuth2Flow {
        AUTHORIZATION_CODE_GRANT("Authorization Code Grant"),
        IMPLICIT_GRANT("Implicit Grant");

        private String description;

        private OAuth2Flow(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum AccessTokenPosition {
        QUERY("Query"),
        HEADER("Header"),
        BODY("Body");

        private String description;

        private AccessTokenPosition(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum AccessTokenStatus {
        UNKNOWN("Unknown"),
        ENTERED_MANUALLY("Entered Manually"),
        WAITING_FOR_AUTHORIZATION("Waiting for Authorization"),
        RECEIVED_AUTHORIZATION_CODE("Received authorization code"),
        RETRIEVED_FROM_SERVER("Retrieved from server"),
        RETRIEVAL_CANCELED("Retrieval canceled"),
        EXPIRED("Expired");

        private String description;

        private AccessTokenStatus(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

