/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.WadlImporter;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.ModelItemNamer;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;
import java.util.List;

public class NewWadlProjectAction
extends AbstractSoapUIAction<WorkspaceImpl> {
    public static final String SOAPUI_ACTION_ID = "NewWadlProjectAction";
    public static final String DEFAULT_PROJECT_NAME = "REST Project";
    private XFormDialog dialog;
    public static final MessageSupport messages = MessageSupport.getMessages(NewWadlProjectAction.class);

    public NewWadlProjectAction() {
        super(messages.get("Title"), messages.get("Description"));
    }

    @Override
    public void perform(WorkspaceImpl workspace, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
        }
        if (param instanceof String) {
            this.dialog.setValue(Form.INITIALWADL, param.toString());
        } else {
            this.dialog.setValue(Form.INITIALWADL, "");
        }
        while (this.dialog.show()) {
            WsdlProject project = null;
            try {
                String projectName = this.createProjectName(this.dialog.getFormField(Form.INITIALWADL).getValue(), workspace.getProjectList());
                if (projectName.length() == 0) {
                    UISupport.showErrorMessage(messages.get("MissingProjectNameError"));
                    continue;
                }
                project = workspace.createProject(projectName, null);
                if (project == null) continue;
                UISupport.select(project);
                String url = this.dialog.getValue(Form.INITIALWADL).trim();
                if (url.length() > 0) {
                    if (new File(url).exists()) {
                        url = new File(url).toURI().toURL().toString();
                    }
                    if (url.toUpperCase().endsWith("WADL")) {
                        this.importWadl(project, url);
                    }
                }
                this.showDeepestEditor(project);
                break;
            }
            catch (InvalidDefinitionException ex) {
                ex.show();
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
                if (project == null) continue;
                workspace.removeProject(project);
            }
        }
    }

    private void showDeepestEditor(WsdlProject project) {
        ModelItem item = this.findLeafItem(project);
        if (item != null) {
            UISupport.select(item);
            UISupport.showDesktopPanel(item);
        }
    }

    private ModelItem findLeafItem(ModelItem item) {
        if (item.getChildren().isEmpty()) {
            return item;
        }
        return this.findLeafItem(item.getChildren().get(0));
    }

    public String createProjectName(String filePath, List<? extends Project> projectList) {
        if (StringUtils.hasContent(filePath)) {
            String projectName = filePath;
            int ix = projectName.lastIndexOf(46);
            if (ix > 0) {
                projectName = projectName.substring(0, ix);
            }
            if ((ix = projectName.lastIndexOf(47)) == -1) {
                ix = projectName.lastIndexOf(92);
            }
            if (ix != -1) {
                projectName = projectName.substring(ix + 1);
            }
            if (!StringUtils.isNullOrEmpty(projectName)) {
                return projectName;
            }
        }
        return ModelItemNamer.createName(DEFAULT_PROJECT_NAME, projectList);
    }

    private void importWadl(WsdlProject project, String url) {
        RestService restService = (RestService)project.addNewInterface(project.getName(), "rest");
        UISupport.select(restService);
        try {
            new WadlImporter(restService).initFromWadl(url);
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="http://www.soapui.org/REST-Testing/working-with-rest-services.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.InitialWadl.Description", type=AField.AFieldType.FILE)
        public static final String INITIALWADL = messages.get("Form.InitialWadl.Label");
    }
}

