/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.l2fprod.common.swing.JFontChooser;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class EditorPrefs
implements Prefs {
    public static final String NO_RESIZE_REQUEST_EDITOR = "Disable auto-resize";
    public static final String START_WITH_REQUEST_TABS = "Tabbed request view";
    public static final String AUTO_VALIDATE_REQUEST = "Validate Requests";
    public static final String ABORT_ON_INVALID_REQUEST = "Abort on invalid";
    public static final String AUTO_VALIDATE_RESPONSE = "Validate Responses";
    public static final String XML_LINE_NUMBERS = "XML Line Numbers";
    public static final String GROOVY_LINE_NUMBERS = "Groovy Line Numbers";
    private JTextField editorFontTextField;
    private SimpleForm editorForm;
    private final String title;
    private JCheckBox abortCheckBox;
    private JCheckBox autoValidateCheckBox;

    public EditorPrefs(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public SimpleForm getForm() {
        if (this.editorForm == null) {
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.editorFontTextField = new JTextField(20);
            this.editorFontTextField.setEnabled(false);
            builder.addFixed((JComponent)this.editorFontTextField);
            builder.addRelatedGap();
            builder.addFixed((JComponent)new JButton(new AbstractAction("Select Font.."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Font font = JFontChooser.showDialog((Component)UISupport.getMainFrame(), (String)"Select XML Editor Font", (Font)Font.decode(EditorPrefs.this.editorFontTextField.getText()));
                    if (font != null) {
                        EditorPrefs.this.editorFontTextField.setText(EditorPrefs.encodeFont(font));
                    }
                }
            }));
            this.editorForm = new SimpleForm();
            this.editorForm.addSpace(5);
            this.editorForm.append("Editor Font", builder.getPanel());
            this.editorForm.appendSeparator();
            this.editorForm.appendCheckBox(XML_LINE_NUMBERS, "Show line numbers in XML editors by default", true);
            this.editorForm.appendCheckBox(GROOVY_LINE_NUMBERS, "Show line numbers in Groovy editors by default", true);
            this.editorForm.appendSeparator();
            this.editorForm.appendCheckBox(NO_RESIZE_REQUEST_EDITOR, "Disables automatic resizing of Request editors", true);
            this.editorForm.appendCheckBox(START_WITH_REQUEST_TABS, "Defaults the Request editor to the tabbed layout", true);
            this.editorForm.appendSeparator();
            this.autoValidateCheckBox = this.editorForm.appendCheckBox(AUTO_VALIDATE_REQUEST, "Always validate request messages before they are sent", true);
            this.abortCheckBox = this.editorForm.appendCheckBox(ABORT_ON_INVALID_REQUEST, "Abort invalid requests", true);
            this.editorForm.appendCheckBox(AUTO_VALIDATE_RESPONSE, "Always validate response messages", true);
            this.autoValidateCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorPrefs.this.abortCheckBox.setEnabled(EditorPrefs.this.autoValidateCheckBox.isSelected());
                }
            });
        }
        return this.editorForm;
    }

    @Override
    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        this.editorForm.getValues(values);
        this.storeValues(values, settings);
    }

    @Override
    public void storeValues(StringToStringMap values, Settings settings) {
        if (this.editorFontTextField != null) {
            settings.setString(UISettings.EDITOR_FONT, this.editorFontTextField.getText());
        }
        settings.setBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR, values.getBoolean(NO_RESIZE_REQUEST_EDITOR));
        settings.setBoolean(UISettings.START_WITH_REQUEST_TABS, values.getBoolean(START_WITH_REQUEST_TABS));
        settings.setBoolean(UISettings.AUTO_VALIDATE_REQUEST, values.getBoolean(AUTO_VALIDATE_REQUEST));
        settings.setBoolean(UISettings.ABORT_ON_INVALID_REQUEST, values.getBoolean(ABORT_ON_INVALID_REQUEST));
        settings.setBoolean(UISettings.AUTO_VALIDATE_RESPONSE, values.getBoolean(AUTO_VALIDATE_RESPONSE));
        settings.setBoolean(UISettings.SHOW_XML_LINE_NUMBERS, values.getBoolean(XML_LINE_NUMBERS));
        settings.setBoolean(UISettings.SHOW_GROOVY_LINE_NUMBERS, values.getBoolean(GROOVY_LINE_NUMBERS));
    }

    public static String encodeFont(Font font) {
        String editorFont = font.getFontName() + " ";
        if (font.isBold()) {
            editorFont = editorFont + "bold ";
        }
        if (font.isItalic()) {
            editorFont = editorFont + "italic ";
        }
        editorFont = editorFont + font.getSize();
        return editorFont;
    }

    @Override
    public void setFormValues(Settings settings) {
        this.editorFontTextField.setText(EditorPrefs.encodeFont(UISupport.getEditorFont()));
        this.editorForm.setValues(this.getValues(settings));
        this.abortCheckBox.setEnabled(settings.getBoolean(UISettings.AUTO_VALIDATE_REQUEST));
    }

    @Override
    public StringToStringMap getValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        values.put(NO_RESIZE_REQUEST_EDITOR, settings.getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR));
        values.put(START_WITH_REQUEST_TABS, settings.getBoolean(UISettings.START_WITH_REQUEST_TABS));
        values.put(AUTO_VALIDATE_REQUEST, settings.getBoolean(UISettings.AUTO_VALIDATE_REQUEST));
        values.put(ABORT_ON_INVALID_REQUEST, settings.getBoolean(UISettings.ABORT_ON_INVALID_REQUEST));
        values.put(AUTO_VALIDATE_RESPONSE, settings.getBoolean(UISettings.AUTO_VALIDATE_RESPONSE));
        values.put(XML_LINE_NUMBERS, settings.getBoolean(UISettings.SHOW_XML_LINE_NUMBERS));
        values.put(GROOVY_LINE_NUMBERS, settings.getBoolean(UISettings.SHOW_GROOVY_LINE_NUMBERS));
        return values;
    }
}

