/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.weakness;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.option.PayloadElement;
import wsattacker.library.signatureWrapping.option.SignedElement;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessInterface;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.signatureWrapping.xpath.weakness.util.XPathWeaknessTools;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class EnvelopedTransformationWeakness
implements XPathWeaknessInterface {
    private int numberOfPossibilities;
    private XPathWeaknessInterface realWeakness;

    public EnvelopedTransformationWeakness(XPathWeaknessInterface realWeakness, SignedElement signedElement) throws InvalidWeaknessException {
        Element signaturePart = signedElement.getRefferringElement();
        Element signedContent = signedElement.getSignedElement();
        if (XPathWeaknessTools.isAncestorOf(signedContent, signaturePart) < 1) {
            throw new InvalidWeaknessException("Not an envelopped signature.");
        }
        this.realWeakness = realWeakness;
        this.numberOfPossibilities = 2;
    }

    @Override
    public int getNumberOfPossibilities() {
        return this.numberOfPossibilities * this.realWeakness.getNumberOfPossibilities();
    }

    @Override
    public void abuseWeakness(int index, SignedElement signedElement, PayloadElement payloadElement) throws InvalidWeaknessException {
        int realIndex = index / 2;
        boolean remove = index % 2 == 1;
        this.realWeakness.abuseWeakness(realIndex, signedElement, payloadElement);
        if (remove) {
            boolean success = false;
            Node tmp = signedElement.getRefferringElement();
            while (tmp.getParentNode() != null) {
                if (tmp.getLocalName().equals("Signature") && tmp.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                    String fastXPath = DomUtilities.getFastXPath((Node)tmp);
                    tmp.getParentNode().removeChild(tmp);
                    WeaknessLog.append("Enveloped Signature Transformation: Removed " + fastXPath);
                    success = true;
                    break;
                }
                tmp = tmp.getParentNode();
            }
            if (!success) {
                WeaknessLog.append("Enveloped Signature Transformation: ### ERROR: Could not remove ");
            }
        }
    }
}

