/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.parts.predicate;

import java.util.ArrayList;
import java.util.List;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathPartInterface;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.OrExpression;
import wsattacker.library.signatureWrapping.xpath.parts.util.XPathInspectorTools;

public class Predicate
implements XPathPartInterface {
    private final String predicate;
    private final List<OrExpression> orExpressions;

    public Predicate(String predicate) {
        this.predicate = predicate;
        this.orExpressions = new ArrayList<OrExpression>();
        this.eval();
    }

    public String getPredicate() {
        return this.predicate;
    }

    public List<OrExpression> getOrExpressions() {
        return this.orExpressions;
    }

    public String toString() {
        return this.predicate;
    }

    @Override
    public String toFullString() {
        return XPathInspectorTools.implodeList(this.orExpressions, " ");
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.equals(new Predicate((String)o));
        }
        if (o instanceof Predicate) {
            return ((Predicate)o).getOrExpressions().equals(this.getOrExpressions());
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.predicate != null ? this.predicate.hashCode() : 0);
        return hash;
    }

    private void eval() {
        String orString;
        int prevOr = 0;
        int nextOr = XPathInspectorTools.nextString(this.predicate, " or ", prevOr);
        while (nextOr > 0) {
            orString = this.predicate.substring(prevOr, nextOr).trim();
            if (!orString.isEmpty()) {
                this.orExpressions.add(new OrExpression(orString));
            }
            prevOr = nextOr + 4;
            nextOr = XPathInspectorTools.nextString(this.predicate, " or ", prevOr);
        }
        orString = this.predicate.substring(prevOr).trim();
        if (!orString.isEmpty()) {
            this.orExpressions.add(new OrExpression(orString));
        }
    }
}

