/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.parts.predicate;

import java.util.ArrayList;
import java.util.List;
import wsattacker.library.signatureWrapping.xpath.interfaces.ExpressionInterface;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathPartInterface;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.AndExpression;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.factory.AndExpressionFactory;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.factory.AndExpressionFactoryInterface;
import wsattacker.library.signatureWrapping.xpath.parts.util.XPathInspectorTools;

public class OrExpression
implements XPathPartInterface,
ExpressionInterface {
    public static AndExpressionFactoryInterface andFactory = new AndExpressionFactory();
    private final String expression;
    private final List<AndExpression> andExpressions;

    public OrExpression(String expression) {
        this.expression = expression;
        this.andExpressions = new ArrayList<AndExpression>();
        this.eval();
    }

    public List<AndExpression> getAndExpressions() {
        return this.andExpressions;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression;
    }

    @Override
    public String toFullString() {
        return XPathInspectorTools.implodeList(this.andExpressions, " ");
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.equals(new OrExpression((String)o));
        }
        if (o instanceof OrExpression) {
            return this.expression.equals(((ExpressionInterface)o).getExpression());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.expression != null ? this.expression.hashCode() : 0);
        return hash;
    }

    private void eval() {
        String andString;
        int prevAnd = 0;
        int nextAnd = XPathInspectorTools.nextString(this.expression, " and ", prevAnd);
        while (nextAnd > 0) {
            andString = this.expression.substring(prevAnd, nextAnd).trim();
            if (!andString.isEmpty()) {
                this.andExpressions.add(andFactory.createAndExpression(andString));
            }
            prevAnd = nextAnd + 5;
            nextAnd = XPathInspectorTools.nextString(this.expression, " and ", prevAnd);
        }
        andString = this.expression.substring(prevAnd).trim();
        if (!andString.isEmpty()) {
            this.andExpressions.add(andFactory.createAndExpression(andString));
        }
    }
}

