/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.analysis;

import java.util.List;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.option.PayloadElement;
import wsattacker.library.signatureWrapping.option.SignedElement;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.util.signature.ReferringElementInterface;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessFactoryInterface;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessInterface;
import wsattacker.library.signatureWrapping.xpath.parts.AbsoluteLocationPath;
import wsattacker.library.signatureWrapping.xpath.parts.Step;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.AndExpression;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.Predicate;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.concrete.AttributeAndExpression;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.concrete.LocalNameAndExpression;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.concrete.NamespaceUriAndExpression;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.concrete.PositionAndExpression;
import wsattacker.library.signatureWrapping.xpath.weakness.XPathWeaknessFactory;

public class XPathAnalyser {
    public static XPathWeaknessFactoryInterface xpathWeaknessFactory = new XPathWeaknessFactory();
    private final AbsoluteLocationPath xpath;
    private final List<XPathWeaknessInterface> weaknesses;
    int maxPossibilites;

    public XPathAnalyser(ReferringElementInterface ref, SignedElement signedElement, PayloadElement payloadElement, SchemaAnalyzer schemaAnalyzer) {
        this.xpath = new AbsoluteLocationPath(ref);
        this.weaknesses = xpathWeaknessFactory.generate(this.xpath, signedElement, payloadElement, schemaAnalyzer);
        this.maxPossibilites = 0;
        for (XPathWeaknessInterface w : this.weaknesses) {
            this.maxPossibilites += w.getNumberOfPossibilities();
        }
    }

    public XPathAnalyser(String xpath, SignedElement signedElement, PayloadElement payloadElement, SchemaAnalyzer schemaAnalyser) {
        this.xpath = new AbsoluteLocationPath(xpath);
        this.weaknesses = xpathWeaknessFactory.generate(this.xpath, signedElement, payloadElement, schemaAnalyser);
        this.maxPossibilites = 0;
        for (XPathWeaknessInterface w : this.weaknesses) {
            this.maxPossibilites += w.getNumberOfPossibilities();
        }
    }

    public List<XPathWeaknessInterface> getWeaknesses() {
        return this.weaknesses;
    }

    public AbsoluteLocationPath getXPath() {
        return this.xpath;
    }

    public int getMaxPossibilites() {
        return this.maxPossibilites;
    }

    public void abuseWeakness(int possibility, SignedElement signedElement, PayloadElement payloadElement) throws InvalidWeaknessException {
        if (possibility >= this.maxPossibilites) {
            return;
        }
        for (int i = 0; i < this.weaknesses.size(); ++i) {
            XPathWeaknessInterface w = this.weaknesses.get(i);
            int num = w.getNumberOfPossibilities();
            if (possibility < num) {
                w.abuseWeakness(possibility, signedElement, payloadElement);
                return;
            }
            possibility -= num;
        }
    }

    public boolean isFastXPath() {
        for (Step step : this.xpath.getRelativeLocationPaths()) {
            if (!step.getAxisSpecifier().getAxisName().toFullString().equals("child")) {
                return false;
            }
            if (step.getAxisSpecifier().getNodeType() != null) {
                return false;
            }
            if (step.getAxisSpecifier().getNodeName() == null) {
                return false;
            }
            if (step.getAxisSpecifier().getNodeName().getNodeName().isEmpty()) {
                return false;
            }
            List<Predicate> predicates = step.getPredicates();
            if (predicates.isEmpty() || predicates.size() > 2) {
                return false;
            }
            int positions = 0;
            int attributes = 0;
            for (Predicate pred : step.getPredicates()) {
                if (pred.getOrExpressions().size() != 1) {
                    return false;
                }
                if (pred.getOrExpressions().get(0).getAndExpressions().size() != 1) {
                    return false;
                }
                AndExpression and = pred.getOrExpressions().get(0).getAndExpressions().get(0);
                if (and instanceof PositionAndExpression) {
                    ++positions;
                    continue;
                }
                if (!(and instanceof AttributeAndExpression)) continue;
                ++attributes;
            }
            if (positions <= 1 && attributes <= 1 && attributes + positions != 0) continue;
            return false;
        }
        return true;
    }

    public boolean isPrefixfreeTransformedFastXPath() {
        for (Step step : this.xpath.getRelativeLocationPaths()) {
            if (!step.getAxisSpecifier().getAxisName().toFullString().equals("child")) {
                return false;
            }
            if (step.getAxisSpecifier().getNodeName() != null) {
                return false;
            }
            if (step.getAxisSpecifier().getNodeType() == null) {
                return false;
            }
            if (!step.getAxisSpecifier().getNodeType().getNodeTypeName().equals("node")) {
                return false;
            }
            List<Predicate> predicates = step.getPredicates();
            if (predicates.isEmpty() || predicates.size() > 3) {
                return false;
            }
            int positions = 0;
            int attributes = 0;
            int ln = 0;
            int uri = 0;
            for (Predicate pred : step.getPredicates()) {
                if (pred.getOrExpressions().size() != 1) {
                    return false;
                }
                if (pred.getOrExpressions().get(0).getAndExpressions().size() != 1) {
                    List<AndExpression> andExpressions = pred.getOrExpressions().get(0).getAndExpressions();
                    if (andExpressions.size() > 2 || andExpressions.size() < 1) {
                        return false;
                    }
                    for (AndExpression and : andExpressions) {
                        if (and instanceof LocalNameAndExpression) {
                            ++ln;
                            continue;
                        }
                        if (!(and instanceof NamespaceUriAndExpression)) continue;
                        ++uri;
                    }
                    continue;
                }
                AndExpression and = pred.getOrExpressions().get(0).getAndExpressions().get(0);
                if (and instanceof PositionAndExpression) {
                    ++positions;
                    continue;
                }
                if (!(and instanceof AttributeAndExpression)) continue;
                ++attributes;
            }
            if (ln == 1 && uri == 1 && positions <= 1 && attributes <= 1 && attributes + positions != 0) continue;
            return false;
        }
        return true;
    }
}

