/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.util.timestamp;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public final class SamlConditionsUpdater {
    public static final DateFormat inMilli = new XmlSchemaDateFormat();
    public static final DateFormat normal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static DateFormat df = inMilli;
    public static final String XPATH_NOT_BEFORE = "//attribute::*[local-name()='NotBefore']";
    public static final String XPATH_NOT_ON_OR_AFTER = "//attribute::*[local-name()='NotOnOrAfter']";

    private SamlConditionsUpdater() {
    }

    public static void updateConditionsElement(Element conditionsElement, int beforeSec, int afterSec) {
        Calendar notBefore = Calendar.getInstance();
        Calendar notOnOrAfter = (Calendar)notBefore.clone();
        notBefore.add(13, -1 * beforeSec);
        notOnOrAfter.add(13, afterSec);
        conditionsElement.setAttribute("NotBefore", df.format(notBefore.getTime()));
        conditionsElement.setAttribute("NotOnOrAfter", df.format(notOnOrAfter.getTime()));
    }

    public static void updateTimestamps(Document document, int beforeSeconds, int afterSeconds) {
        Calendar notBefore = Calendar.getInstance();
        notBefore.add(13, -1 * beforeSeconds);
        Calendar notOnOrAfter = Calendar.getInstance();
        notOnOrAfter.setTime(notBefore.getTime());
        notOnOrAfter.add(13, afterSeconds);
        SamlConditionsUpdater.updateTimestamps(document, notBefore, notOnOrAfter);
    }

    public static void updateTimestamps(Document document, Calendar notBefore, Calendar notOnOrAfter) {
        try {
            XmlSchemaDateFormat df = new XmlSchemaDateFormat();
            List notBeforeList = DomUtilities.evaluateXPath((Document)document, (String)XPATH_NOT_BEFORE);
            for (Node n : notBeforeList) {
                Attr notBeforeAttr = (Attr)n;
                notBeforeAttr.setTextContent(df.format(notBefore.getTime()));
            }
            List notOnOrAfterList = DomUtilities.evaluateXPath((Document)document, (String)XPATH_NOT_ON_OR_AFTER);
            for (Node n : notOnOrAfterList) {
                Attr notOnOrAfterAttr = (Attr)n;
                notOnOrAfterAttr.setTextContent(df.format(notOnOrAfter.getTime()));
            }
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(SamlConditionsUpdater.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void updateTimestampsByXPath(Document document, String xpathToFindTimestampAttr, Calendar calendar) throws XPathExpressionException {
        List attrList = DomUtilities.evaluateXPath((Document)document, (String)XPATH_NOT_BEFORE);
        for (Node n : attrList) {
            Attr notBefore = (Attr)n;
            notBefore.setTextContent(df.format(calendar.getTime()));
        }
    }
}

