/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.util.signature;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.signatureWrapping.util.signature.ReferringElementInterface;
import wsattacker.library.signatureWrapping.util.signature.XPathElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class ReferenceElement
implements ReferringElementInterface {
    private static final String URI_XPATHFILTER2 = "http://www.w3.org/2002/06/xmldsig-filter2";
    private final Element reference;
    private Element referencedElement;
    private Payload payload;
    private final List<XPathElement> xpaths = new ArrayList<XPathElement>();
    private String workingXPath;
    public static final Logger LOG = Logger.getLogger(ReferenceElement.class);

    public ReferenceElement(Element reference) {
        this.reference = reference;
        this.payload = null;
        this.workingXPath = "";
        if (this.getURI().isEmpty()) {
            this.searchForXPaths(reference);
        } else {
            this.handleURI(reference);
        }
    }

    public Element getReference() {
        return this.reference;
    }

    @Override
    public Element getElementNode() {
        return this.reference;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public String getURI() {
        return this.reference.getAttribute("URI");
    }

    public Element getReferencedElement() {
        return this.referencedElement;
    }

    public List<XPathElement> getXPaths() {
        return this.xpaths;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof ReferenceElement) {
            ReferenceElement ref = (ReferenceElement)o;
            result = ref.getURI().equals(this.getURI()) && ref.getXPaths().equals(this.getXPaths());
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.getURI() != null ? this.getURI().hashCode() : 0);
        hash = 29 * hash + (this.getXPaths() != null ? this.getXPaths().hashCode() : 0);
        return hash;
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    public String transformIDtoXPath() {
        String value;
        String name;
        Attr id = this.referencedElement.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null) {
            for (int i = 0; i < this.referencedElement.getAttributes().getLength() && !(id = (Attr)this.referencedElement.getAttributes().item(i)).getValue().equals(this.getURI().substring(1)); ++i) {
            }
        }
        if (id.getPrefix() != null) {
            name = id.getPrefix() + ":" + id.getLocalName();
            value = id.getValue();
        } else {
            name = id.getLocalName();
            value = id.getValue();
        }
        return String.format("//*[@%s='%s']", name, value);
    }

    @Override
    public String getXPath() {
        if (this.workingXPath.isEmpty()) {
            this.workingXPath = this.transformIDtoXPath();
        }
        return this.workingXPath;
    }

    @Override
    public void setXPath(String workingXPath) {
        this.workingXPath = workingXPath;
    }

    public String toString() {
        return String.format("URI=\"%s\"", this.getURI());
    }

    private void searchForXPaths(Element reference) {
        this.log().trace((Object)"URI is empty => Searching XPath Transformations");
        List transforms = DomUtilities.findChildren((Node)reference, (String)"Transforms", (String)"http://www.w3.org/2000/09/xmldsig#");
        if (1 == transforms.size()) {
            List transform = DomUtilities.findChildren((Node)((Node)transforms.get(0)), (String)"Transform", (String)"http://www.w3.org/2000/09/xmldsig#");
            this.log().trace((Object)String.format("Found Transforms child element >> %s << whith child elements >> %s <<", transforms, transform));
            for (Element t : transform) {
                if (t.getAttribute("Algorithm").equals(URI_XPATHFILTER2)) {
                    List xpathElements = DomUtilities.findChildren((Node)t, (String)"XPath", null);
                    this.log().trace((Object)String.format("Element >> %s << has the XPathFilter2 Algorithm and child elements >> %s <<", t.getNodeName(), xpathElements));
                    for (Element xpath : xpathElements) {
                        this.xpaths.add(new XPathElement(xpath));
                    }
                    break;
                }
                this.log().trace((Object)String.format("Element >> %s << has NO XPathFilter2 Algorithm!", t.getNodeName()));
            }
        } else {
            this.log().warn((Object)String.format("Found >> %d << Transforms. This is invalid.", transforms.size()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleURI(Element reference) throws NullPointerException {
        ref = this.getURI();
        if (ref.charAt(0) == '#') {
            ref = ref.substring(1);
        }
        try {
            referenced = DomUtilities.evaluateXPath((Document)reference.getOwnerDocument(), (String)String.format("//*[@Id='%s']", new Object[]{ref}));
        }
        catch (XPathExpressionException e) {
            referenced = new ArrayList<E>();
        }
        if (referenced.isEmpty()) {
            referenced = DomUtilities.findElementByWsuId((Document)reference.getOwnerDocument(), (String)ref);
        }
        if (referenced.isEmpty()) {
            referenced = DomUtilities.findAttributeByValue((Document)reference.getOwnerDocument(), (String)ref);
        }
        if (referenced.size() != 1) ** GOTO lbl22
        n = (Node)referenced.get(0);
        if (n.getNodeType() == 1) {
            this.referencedElement = (Element)referenced.get(0);
        } else if (n.getNodeType() == 2) {
            this.referencedElement = ((Attr)referenced.get(0)).getOwnerElement();
        } else {
            throw new NullPointerException("Don't know how to handle match:" + n.toString() + "(" + n.getClass().getName() + ")");
lbl22:
            // 1 sources

            if (referenced.size() > 1) {
                try {
                    attrList = referenced;
                    ReferenceElement.LOG.warn((Object)("There are " + referenced.size() + " possible References which machtes the URI '" + ref + "' (" + DomUtilities.nodelistToFastXPathList(referenced) + "). This is invalid and must produce errors."));
                    for (Attr attribute : attrList) {
                        if (!attribute.getLocalName().toLowerCase().equals("assertionid")) continue;
                        this.referencedElement = attribute.getOwnerElement();
                    }
                    if (this.referencedElement == null) {
                        for (Attr attribute : attrList) {
                            if (!attribute.getLocalName().toLowerCase().equals("id")) continue;
                            this.referencedElement = attribute.getOwnerElement();
                        }
                    }
                    if (this.referencedElement != null) ** GOTO lbl46
                    for (Attr attribute : attrList) {
                        if (!attribute.getLocalName().toLowerCase().contains("id")) continue;
                        this.referencedElement = attribute.getOwnerElement();
                    }
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("This should never happen", e);
                }
            } else if (referenced.isEmpty()) {
                ReferenceElement.LOG.warn((Object)String.format("Could not find any References which machtes the URI >> %s <<. No Signed Element found.", new Object[]{ref}));
                throw new NullPointerException("Could not de-reference signed element");
            }
        }
lbl46:
        // 6 sources

        this.payload = new Payload(this, this.referencedElement);
    }
}

