# frozen_string_literal: true

require_relative '../../../spec_helper'

describe Wpxf::WordPress::User do
  let(:body) { '' }
  let(:code) { 200 }
  let(:subject) do
    subject = Class.new(Wpxf::Module) do
      include Wpxf::Net::HttpClient
      include Wpxf::WordPress::Options
      include Wpxf::WordPress::Urls
      include Wpxf::WordPress::User
    end.new

    subject.set_option_value('host', '127.0.0.1')
    subject.set_option_value('target_uri', '/wp/')
    subject
  end

  before :each do
    res = Wpxf::Net::HttpResponse.new(nil)
    res.body = body
    res.code = code

    allow(subject).to receive(:execute_request).and_return(res)
  end

  describe '#wordpress_user_exists?' do
    let(:body) { 'Incorrect password' }
    it 'returns true if the login response indicates the user exists' do
      expect(subject.wordpress_user_exists?('foo')).to be true
    end
  end

  describe '#wordpress_user_profile_form_fields' do
    context 'when the profile form is accessible and contains a valid form' do
      let(:code) { 200 }
      let(:body) { '<form><input name="key" value="value"><input name="foo" required value="bar"/>' }
      it 'returns a hash constructed from the input elements in the profile form' do
        fields = subject.wordpress_user_profile_form_fields('')
        expect(fields).to eq('key' => 'value', 'foo' => 'bar')
      end
    end

    context 'when the profile form is accessible and contains no form elements' do
      let(:code) { 200 }
      let(:body) { '<form></form>' }
      it 'returns an empty hash' do
        expect(subject.wordpress_user_profile_form_fields('')).to eq({})
      end
    end

    context 'when the profile form request returns a code != 200' do
      let(:code) { 404 }
      let(:body) { nil }
      it 'returns nil' do
        expect(subject.wordpress_user_profile_form_fields('')).to be_nil
      end
    end
  end
end
