# frozen_string_literal: true

require_relative '../../../spec_helper'

describe Wpxf::WordPress::Urls do
  let(:subject) do
    subject = Class.new(Wpxf::Module) do
      include Wpxf::WordPress::Options
      include Wpxf::WordPress::Urls
    end.new

    subject.set_option_value('host', '127.0.0.1')
    subject.set_option_value('target_uri', '/wp/')
    subject
  end

  describe '#wordpress_url_login' do
    it 'returns the WordPress login URL' do
      url = 'http://127.0.0.1/wp/wp-login.php'
      expect(subject.wordpress_url_login).to eq url
    end
  end

  describe '#wordpress_url_post' do
    it 'returns URL of the specified WordPress post' do
      url = 'http://127.0.0.1/wp/?p=10'
      expect(subject.wordpress_url_post(10)).to eq url
    end
  end

  describe '#wordpress_url_author' do
    it 'returns the WordPress author URL' do
      url = 'http://127.0.0.1/wp/?author=10'
      expect(subject.wordpress_url_author(10)).to eq url
    end
  end

  describe '#wordpress_url_rss' do
    it 'returns the WordPress RSS URL' do
      url = 'http://127.0.0.1/wp/?feed=rss2'
      expect(subject.wordpress_url_rss).to eq url
    end
  end

  describe '#wordpress_url_rdf' do
    it 'returns the WordPress RDF URL' do
      url = 'http://127.0.0.1/wp/feed/rdf/'
      expect(subject.wordpress_url_rdf).to eq url
    end
  end

  describe '#wordpress_url_atom' do
    it 'returns the WordPress ATOM URL' do
      url = 'http://127.0.0.1/wp/feed/atom/'
      expect(subject.wordpress_url_atom).to eq url
    end
  end

  describe '#wordpress_url_readme' do
    it 'returns the WordPress readme file URL' do
      url = 'http://127.0.0.1/wp/readme.html'
      expect(subject.wordpress_url_readme).to eq url
    end
  end

  describe '#wordpress_url_sitemap' do
    it 'returns the WordPress sitemap URL' do
      url = 'http://127.0.0.1/wp/sitemap.xml'
      expect(subject.wordpress_url_sitemap).to eq url
    end
  end

  describe '#wordpress_url_opml' do
    it 'returns the WordPress OPML URL' do
      url = 'http://127.0.0.1/wp/wp-links-opml.php'
      expect(subject.wordpress_url_opml).to eq url
    end
  end

  describe '#wordpress_url_admin' do
    it 'returns the WordPress admin URL' do
      url = 'http://127.0.0.1/wp/wp-admin/'
      expect(subject.wordpress_url_admin).to eq url
    end
  end

  describe '#wordpress_url_admin_ajax' do
    it 'returns the WordPress admin AJAX URL' do
      url = 'http://127.0.0.1/wp/wp-admin/admin-ajax.php'
      expect(subject.wordpress_url_admin_ajax).to eq url
    end
  end

  describe '#wordpress_url_admin_post' do
    it 'returns the WordPress admin post URL' do
      url = 'http://127.0.0.1/wp/wp-admin/admin-post.php'
      expect(subject.wordpress_url_admin_post).to eq url
    end
  end

  describe '#wordpress_url_admin_update' do
    it 'returns the WordPress admin update URL' do
      url = 'http://127.0.0.1/wp/wp-admin/update.php'
      expect(subject.wordpress_url_admin_update).to eq url
    end
  end

  describe '#wordpress_url_wp_content' do
    it 'returns the WordPress wp-content URL' do
      url = 'http://127.0.0.1/wp/wp-content'
      expect(subject.wordpress_url_wp_content).to eq url
    end
  end

  describe '#wordpress_url_plugins' do
    it 'returns the WordPress plugins URL' do
      url = 'http://127.0.0.1/wp/wp-content/plugins'
      expect(subject.wordpress_url_plugins).to eq url
    end
  end

  describe '#wordpress_url_themes' do
    it 'returns the WordPress themes URL' do
      url = 'http://127.0.0.1/wp/wp-content/themes'
      expect(subject.wordpress_url_themes).to eq url
    end
  end

  describe '#wordpress_url_xmlrpc' do
    it 'returns the WordPress XMLRPC URL' do
      url = 'http://127.0.0.1/wp/xmlrpc.php'
      expect(subject.wordpress_url_xmlrpc).to eq url
    end
  end

  describe '#wordpress_url_plugin_install' do
    it 'returns the WordPress plugin install URL' do
      url = 'http://127.0.0.1/wp/wp-admin/plugin-install.php'
      expect(subject.wordpress_url_plugin_install).to eq url
    end
  end

  describe '#wordpress_url_plugin_upload' do
    it 'returns the WordPress plugin uploader URL' do
      url = 'http://127.0.0.1/wp/wp-admin/plugin-install.php?tab=upload'
      expect(subject.wordpress_url_plugin_upload).to eq url
    end
  end

  describe '#wordpress_url_new_user' do
    it 'returns the WordPress new user URL' do
      url = 'http://127.0.0.1/wp/wp-admin/user-new.php'
      expect(subject.wordpress_url_new_user).to eq url
    end
  end

  describe '#wordpress_url_uploads' do
    it 'returns the WordPress uploads URL' do
      url = 'http://127.0.0.1/wp/wp-content/uploads'
      expect(subject.wordpress_url_uploads).to eq url
    end
  end

  describe '#wordpress_url_admin_profile' do
    it 'returns the edit profile page URL' do
      url = 'http://127.0.0.1/wp/wp-admin/profile.php'
      expect(subject.wordpress_url_admin_profile).to eq url
    end
  end

  describe '#wordpress_url_rest_api' do
    it 'returns the REST API base path' do
      url = 'http://127.0.0.1/wp/wp-json'
      expect(subject.wordpress_url_rest_api).to eq url
    end
  end

  describe '#wordpress_url_comments_post' do
    it 'returns the comment poster URL' do
      url = 'http://127.0.0.1/wp/wp-comments-post.php'
      expect(subject.wordpress_url_comments_post).to eq url
    end
  end

  describe '#wordpress_url_admin_options' do
    it 'returns the admin / plugin options URL' do
      url = 'http://127.0.0.1/wp/wp-admin/admin.php'
      expect(subject.wordpress_url_admin_options).to eq url
    end
  end
end
