# frozen_string_literal: true

require_relative '../../../../../spec_helper'
require 'wpxf/modules'

describe Wpxf::Auxiliary::WptfImageGalleryArbitraryFileDownload do
  let(:subject) { described_class.new }

  before :each, 'setup subject' do
    allow(subject).to receive(:check_plugin_version_from_readme)
  end

  it 'should check that the plugin is installed' do
    subject.check
    expect(subject).to have_received(:check_plugin_version_from_readme)
      .with('wptf-image-gallery')
      .exactly(1).times
  end

  it 'should configure the working directory' do
    expected = 'wp-content/plugins/wptf-image-gallery/lib-mbox/'
    expect(subject.working_directory).to eql expected
  end

  it 'should configure the default remote file path' do
    expected = '../../../../wp-config.php'
    expect(subject.default_remote_file_path).to eql expected
  end

  it 'should configure the download request parameters' do
    subject.set_option_value('remote_file', 'wp-config.php')
    expect(subject.download_request_params).to eql(
      'url' => 'wp-config.php'
    )
  end

  it 'should configure the downloader url' do
    expected = %r{plugins/wptf\-image\-gallery/lib\-mbox/ajax_load\.php$}
    expect(subject.downloader_url).to match expected
  end
end
