# frozen_string_literal: true

require_relative '../../../spec_helper'

describe Wpxf::Models::Workspace, type: :model do
  it { is_expected.to have_one_to_many :credentials }
  it { is_expected.to have_one_to_many :loot_items }
  it { is_expected.to validate_presence :name }
  it { is_expected.to validate_format(/^[A-Za-z0-9_]{1,50}$/, :name) }
  it { is_expected.to validate_unique :name }

  describe '#destroy' do
    it 'should destroy associated credentials' do
      subject = Wpxf::Models::Workspace.first
      subject.add_credential(host: 'foo', port: 80, type: 'plain')
      subject.add_credential(host: 'bar', port: 80, type: 'plain')
      expect(Wpxf::Models::Credential.where(port: 80).count).to eql 2

      subject.destroy
      expect(Wpxf::Models::Credential.where(port: 80).count).to eql 0
    end

    it 'should destroy associated loot items' do
      subject = Wpxf::Models::Workspace.first
      subject.add_loot_item(host: 'foo', port: 80, type: 'file', path: 'test')
      subject.add_loot_item(host: 'bar', port: 80, type: 'file', path: 'test')
      expect(Wpxf::Models::LootItem.where(port: 80).count).to eql 2

      subject.destroy
      expect(Wpxf::Models::LootItem.where(port: 80).count).to eql 0
    end
  end
end
