# frozen_string_literal: true

require_relative '../../../spec_helper'

describe Wpxf::Db::Loot do
  let(:subject) { (Class.new { include Wpxf::Db::Loot }).new }

  before(:each) do
    workspace = Wpxf::Models::Workspace.create(name: 'test')

    allow(subject).to receive(:target_host).and_return('example.com')
    allow(subject).to receive(:target_port).and_return(80)
    allow(subject).to receive(:active_workspace).and_return(workspace)
  end

  describe '#store_loot' do
    it 'should insert a new record into the `loot_items` table' do
      expect(Wpxf::Models::LootItem.count).to eql 0
      subject.store_loot 'test'
      expect(Wpxf::Models::LootItem.count).to eql 1
    end

    it 'should transparently set the host information' do
      subject.store_loot 'test'
      loot = Wpxf::Models::LootItem.first
      expect(loot.host).to eql 'example.com'
      expect(loot.port).to eql 80
    end

    it 'should transparently set the workspace information' do
      subject.store_loot 'test'
      loot = Wpxf::Models::LootItem.first
      expect(loot.workspace.name).to eql 'test'
    end

    it 'should optionally store notes' do
      subject.store_loot 'test', 'notes'
      loot = Wpxf::Models::LootItem.first
      expect(loot.notes).to eql 'notes'
    end

    it 'should optionally store the type of loot' do
      subject.store_loot 'test', 'notes', 'type'
      loot = Wpxf::Models::LootItem.first
      expect(loot.type).to eql 'type'
    end

    it 'should set the credential type to `unknown` if not specified' do
      subject.store_loot 'test'
      loot = Wpxf::Models::LootItem.first
      expect(loot.type).to eql 'unknown'
    end
  end
end
