# frozen_string_literal: true

# Provides helper functions for interacting with posts.
module Wpxf::WordPress::Posts
  # Get the post ID from a post body.
  # @param body [String] the body of a post.
  # @return [String,nil] the post ID, nil when nothing found.
  def get_post_id_from_body(body)
    return nil unless body
    res = body.match(/<body class="[^=]*postid-(\d+)[^=]*">/i)
    if res && res[1]
      emit_info "Found post #{res[1]}", true
      return res[1]
    end
    nil
  end

  # Get the post ID from a permalink.
  # @param url [String] the permalink of the post.
  # @return [String,nil] the post ID, nil when nothing found.
  def get_post_id_from_permalink(url)
    res = execute_get_request(url: url)
    return nil unless res && res.code == 200
    get_post_id_from_body(res.body)
  end
end
