# frozen_string_literal: true

module Wpxf
  module Versioning
    # Provides functionality for generating random browser versions.
    module BrowserVersions
      # @return [String] a random IE version string.
      def random_ie_version
        "#{rand(7..9)}.0"
      end

      # @return [String] a random Trident version string.
      def random_trident_version
        "#{rand(3..5)}.#{rand(0..1)}"
      end

      # @return [String] a random Chrome version string.
      def random_chrome_version
        "#{rand(13..15)}.0.#{rand(800..899)}.0"
      end

      # @return [String] a random Presto version string.
      def random_presto_version
        "2.9.#{rand(160..190)}"
      end

      # @return [String] a random second part Presto version string.
      def random_presto_version2
        "#{rand(10..12)}.00"
      end

      # @return [String] a random Safari build number.
      def random_safari_build_number
        "#{rand(531..535)}.#{rand(1..50)}.#{rand(1..7)}"
      end

      # @return [String] a random Safari version number.
      def random_safari_version
        [
          "#{rand(4..5)}.#{rand(0..1)}",
          "#{rand(4..5)}.0.#{rand(1..5)}"
        ].sample
      end

      # @return [String] a random Chrome build number.
      def random_chrome_build_number
        "#{rand(531..536)}.#{rand(0..2)}"
      end

      # @return [String] a random Opera version number.
      def random_opera_version
        "#{rand(8..9)}.#{rand(10..99)}"
      end
    end
  end
end
