# frozen_string_literal: true

module Wpxf
  module Net
    # Provides access to various HTTP based options.
    module HttpOptions
      HTTP_OPTION_HOST = StringOption.new(
        name: 'host',
        desc: 'Address of the target host.',
        required: true
      )

      HTTP_OPTION_PORT = PortOption.new(
        name: 'port',
        desc: 'Port the remote host is listening on',
        required: true,
        default: 80
      )

      HTTP_OPTION_SSL = BooleanOption.new(
        name: 'ssl',
        desc: 'Use SSL/HTTPS for all requests',
        required: true,
        default: false
      )

      HTTP_OPTION_VHOST = StringOption.new(
        name: 'vhost',
        desc: 'HTTP server virtual host'
      )

      HTTP_OPTION_PROXY = StringOption.new(
        name: 'proxy',
        desc: 'Proxy address ([protocol://]host:port)'
      )

      HTTP_OPTION_TARGET_URI = StringOption.new(
        name: 'target_uri',
        desc: 'Base path to the WordPress application',
        required: true,
        default: '/'
      )

      HTTP_OPTION_BASIC_AUTH_CREDS = StringOption.new(
        name: 'basic_auth_creds',
        desc: 'HTTP basic auth credentials (username:password)'
      )

      HTTP_OPTION_PROXY_AUTH_CREDS = StringOption.new(
        name: 'proxy_auth_creds',
        desc: 'Proxy server credentials (username:password)'
      )

      HTTP_OPTION_HOST_VERIFICATION = BooleanOption.new(
        name: 'verify_host',
        desc: 'Enable host verification when using HTTPS',
        required: true,
        default: true
      )

      HTTP_OPTION_PEER_VERIFICATION = BooleanOption.new(
        name: 'verify_peer',
        desc: 'Enable peer verification when using HTTPS',
        required: true,
        default: true
      )

      HTTP_OPTION_MAX_CONCURRENCY = IntegerOption.new(
        name: 'max_http_concurrency',
        desc: 'Max number of HTTP requests that can be made in '\
              'parallel (Min: 1, Max: 200)',
        required: true,
        default: 20,
        min: 1,
        max: 200
      )

      HTTP_OPTION_CLIENT_TIMEOUT = IntegerOption.new(
        name: 'http_client_timeout',
        desc: 'Max wait time in seconds for HTTP responses',
        default: 30,
        required: true
      )

      HTTP_OPTION_USER_AGENT = StringOption.new(
        name: 'user_agent',
        desc: 'The user agent string to send with all requests'
      )

      HTTP_OPTION_FOLLOW_REDIRECT = BooleanOption.new(
        name: 'follow_http_redirection',
        desc: 'Automatically follow HTTP redirections',
        required: true,
        default: true
      )
    end
  end
end
